/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFacade;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.CoverageAccessInfoImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGeoServerFacade
implements GeoServerFacade {
    GeoServerInfo global;
    LoggingInfo logging;
    List<ServiceInfo> services = new ArrayList<ServiceInfo>();
    GeoServer geoServer;

    public DefaultGeoServerFacade(GeoServer geoServer) {
        this.geoServer = geoServer;
        this.global = geoServer.getFactory().createGlobal();
        this.logging = geoServer.getFactory().createLogging();
    }

    @Override
    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    @Override
    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public GeoServerInfo getGlobal() {
        if (this.global == null) {
            return null;
        }
        return ModificationProxy.create(this.global, GeoServerInfo.class);
    }

    @Override
    public void setGlobal(GeoServerInfo global) {
        this.resolve(global);
        this.global = global;
    }

    @Override
    public void save(GeoServerInfo global) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(global);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireGlobalModified(global, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public LoggingInfo getLogging() {
        if (this.logging == null) {
            return null;
        }
        return ModificationProxy.create(this.logging, LoggingInfo.class);
    }

    @Override
    public void setLogging(LoggingInfo logging) {
        this.logging = logging;
    }

    @Override
    public void save(LoggingInfo logging) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(logging);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireLoggingModified(logging, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public void add(ServiceInfo service) {
        service = DefaultGeoServerFacade.unwrap(service);
        service.setGeoServer(this.geoServer);
        this.services.add(service);
    }

    @Override
    public void save(ServiceInfo service) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(service);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireServiceModified(service, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public void remove(ServiceInfo service) {
        this.services.remove(service);
    }

    @Override
    public <T extends ServiceInfo> T getService(Class<T> clazz) {
        for (ServiceInfo si : this.services) {
            if (!clazz.isAssignableFrom(si.getClass())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        return null;
    }

    @Override
    public <T extends ServiceInfo> T getService(String id, Class<T> clazz) {
        for (ServiceInfo si : this.services) {
            if (!id.equals(si.getId())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        return null;
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(String name, Class<T> clazz) {
        for (ServiceInfo si : this.services) {
            if (!name.equals(si.getName())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        return null;
    }

    @Override
    public Collection<? extends ServiceInfo> getServices() {
        return ModificationProxy.createList(this.services, ServiceInfo.class);
    }

    @Override
    public void dispose() {
        if (this.global != null) {
            this.global.dispose();
        }
        if (this.services != null) {
            this.services.clear();
        }
    }

    public static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }

    protected void resolve(GeoServerInfo info) {
        GeoServerInfoImpl global = (GeoServerInfoImpl)info;
        if (global.getMetadata() == null) {
            global.setMetadata(new MetadataMap());
        }
        if (global.getClientProperties() == null) {
            global.setClientProperties(new HashMap<Object, Object>());
        }
        if (global.getCoverageAccess() == null) {
            global.setCoverageAccess(new CoverageAccessInfoImpl());
        }
    }
}

