/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.Iterator;
import org.geoserver.catalog.impl.AbstractDecorator;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecurityUtils;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredIterator
extends AbstractDecorator<Iterator>
implements Iterator,
FeatureIterator {
    WrapperPolicy policy;
    Object current;
    Filter writeFilter;

    public SecuredIterator(Iterator wrapped, WrapperPolicy policy) {
        super(wrapped);
        this.policy = policy;
        this.writeFilter = SecurityUtils.getWriteQuery(policy).getFilter();
    }

    @Override
    public boolean hasNext() {
        return ((Iterator)this.delegate).hasNext();
    }

    public Feature next() {
        this.current = ((Iterator)this.delegate).next();
        return (Feature)this.current;
    }

    @Override
    public void remove() {
        if (!this.writeFilter.evaluate(this.current)) {
            throw this.unsupportedOperation();
        }
        ((Iterator)this.delegate).remove();
    }

    RuntimeException unsupportedOperation() {
        if (this.policy.response == Response.CHALLENGE) {
            return SecureCatalogImpl.unauthorizedAccess();
        }
        return new UnsupportedOperationException("This iterator is read only");
    }

    public void close() {
        if (this.delegate instanceof FeatureIterator) {
            ((FeatureIterator)this.delegate).close();
        }
    }
}

