/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServerDataDirectory;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class GeoServerPropertyConfigurer
extends PropertyPlaceholderConfigurer {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.config");
    GeoServerDataDirectory data;
    Resource location;
    boolean copyOutTemplate = true;
    String comments;

    public GeoServerPropertyConfigurer(GeoServerDataDirectory data) {
        this.data = data;
    }

    public void setCopyOutTemplate(boolean copyOutTemplate) {
        this.copyOutTemplate = copyOutTemplate;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setLocation(Resource location) {
        try {
            File f = location.getFile();
            if (f != null && !f.isAbsolute()) {
                f = new File(this.data.root(), f.getPath());
                this.location = location = new UrlResource(f.toURI());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error reading resource " + location, e);
        }
        super.setLocation(location);
    }

    public void setLocations(Resource[] locations) {
        throw new UnsupportedOperationException("Only a single location is supported");
    }

    protected void loadProperties(Properties props) throws IOException {
        block2: {
            try {
                super.loadProperties(props);
            }
            catch (FileNotFoundException e) {
                if (this.location == null || !this.copyOutTemplate) break block2;
                File f = this.location.getFile();
                f.getParentFile().mkdirs();
                f.createNewFile();
                FileOutputStream fout = new FileOutputStream(f);
                props.store(fout, this.comments);
                fout.flush();
                fout.close();
            }
        }
    }
}

