/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.List;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.test.GeoServerTestSupport;

public class WorkspaceNamespaceConstencyTest
extends GeoServerTestSupport {
    public void testChangeWorkspace() {
        WorkspaceInfo ws = this.getCatalog().getDefaultWorkspace();
        ws.setName(ws.getName() + "abcd");
        this.getCatalog().save(ws);
        NamespaceInfo ns = this.getCatalog().getDefaultNamespace();
        WorkspaceNamespaceConstencyTest.assertNotNull((Object)ns);
        WorkspaceNamespaceConstencyTest.assertEquals((String)ws.getName(), (String)ns.getPrefix());
    }

    public void testChangeNamespace() {
        NamespaceInfo ns = this.getCatalog().getDefaultNamespace();
        ns.setPrefix(ns.getPrefix() + "abcd");
        this.getCatalog().save(ns);
        WorkspaceInfo ws = this.getCatalog().getDefaultWorkspace();
        WorkspaceNamespaceConstencyTest.assertNotNull((Object)ws);
        WorkspaceNamespaceConstencyTest.assertEquals((String)ns.getPrefix(), (String)ws.getName());
    }

    public void testChangeDefaultWorkspace() {
        List workspaces = this.getCatalog().getWorkspaces();
        workspaces.remove(this.getCatalog().getDefaultWorkspace());
        WorkspaceInfo newDefault = (WorkspaceInfo)workspaces.get(0);
        this.getCatalog().setDefaultWorkspace(newDefault);
        NamespaceInfo ns = this.getCatalog().getDefaultNamespace();
        WorkspaceNamespaceConstencyTest.assertNotNull((Object)ns);
        WorkspaceNamespaceConstencyTest.assertEquals((String)newDefault.getName(), (String)ns.getPrefix());
    }

    public void testChangeDefaultNamespace() {
        List namespaces = this.getCatalog().getNamespaces();
        namespaces.remove(this.getCatalog().getDefaultNamespace());
        NamespaceInfo newDefault = (NamespaceInfo)namespaces.get(0);
        this.getCatalog().setDefaultNamespace(newDefault);
        WorkspaceInfo ws = this.getCatalog().getDefaultWorkspace();
        WorkspaceNamespaceConstencyTest.assertNotNull((Object)ws);
        WorkspaceNamespaceConstencyTest.assertEquals((String)newDefault.getName(), (String)ws.getName());
    }

    public void testChangeNamespaceURI() {
        WorkspaceInfo ws = ((DataStoreInfo)this.getCatalog().getStores(DataStoreInfo.class).get(0)).getWorkspace();
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(ws.getName());
        ns.setURI("http://www.geoserver.org/newNamespace");
        this.getCatalog().save(ns);
        List stores = this.getCatalog().getDataStoresByWorkspace(ws);
        WorkspaceNamespaceConstencyTest.assertTrue((stores.size() > 0 ? 1 : 0) != 0);
        for (DataStoreInfo ds : stores) {
            String nsURI = (String)ds.getConnectionParameters().get("namespace");
            if (nsURI == null) continue;
            WorkspaceNamespaceConstencyTest.assertEquals((String)ns.getURI(), (String)nsURI);
        }
    }
}

