/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.util.Collection;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.impl.JAIInfoImpl;
import org.geoserver.config.impl.LoggingInfoImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GeoServerFactoryImpl
implements GeoServerFactory,
ApplicationContextAware {
    GeoServer gs;
    ApplicationContext applicationContext;

    public GeoServerFactoryImpl(GeoServer gs) {
        this.gs = gs;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public GeoServerInfo createGlobal() {
        return new GeoServerInfoImpl(this.gs);
    }

    public ContactInfo createContact() {
        return new ContactInfoImpl();
    }

    public JAIInfo createJAI() {
        return new JAIInfoImpl();
    }

    public MetadataLinkInfo createMetadataLink() {
        return new MetadataLinkInfoImpl();
    }

    public ServiceInfo createService() {
        return new ServiceInfoImpl();
    }

    public LoggingInfo createLogging() {
        return new LoggingInfoImpl();
    }

    public Object create(Class clazz) {
        if (this.applicationContext != null) {
            Collection extensions = this.applicationContext.getBeansOfType(GeoServerFactory.Extension.class).values();
            for (GeoServerFactory.Extension extension : extensions) {
                if (!extension.canCreate(clazz)) continue;
                return extension.create(clazz);
            }
        }
        return null;
    }
}

