/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import junit.framework.TestCase;
import org.geoserver.ows.util.OwsUtils;

public class OwsUtilsTest
extends TestCase {
    public void testSimple() throws Exception {
        Foo foo = new Foo();
        foo.setA("a");
        OwsUtilsTest.assertEquals((Object)"a", (Object)OwsUtils.get((Object)foo, (String)"a"));
        OwsUtilsTest.assertNull((Object)OwsUtils.get((Object)foo, (String)"b"));
        OwsUtils.set((Object)foo, (String)"b", (Object)5);
        OwsUtilsTest.assertEquals((Object)5, (Object)OwsUtils.get((Object)foo, (String)"b"));
        OwsUtilsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)OwsUtils.get((Object)foo, (String)"c"));
        OwsUtils.set((Object)foo, (String)"c", (Object)Float.valueOf(5.0f));
        OwsUtilsTest.assertEquals((Object)Float.valueOf(5.0f), (Object)OwsUtils.get((Object)foo, (String)"c"));
    }

    public void testExtended() throws Exception {
        Bar bar = new Bar();
        OwsUtilsTest.assertNull((Object)OwsUtils.get((Object)bar, (String)"foo"));
        OwsUtilsTest.assertNull((Object)OwsUtils.get((Object)bar, (String)"foo.a"));
        Foo foo = new Foo();
        bar.setFoo(foo);
        OwsUtilsTest.assertEquals((Object)foo, (Object)OwsUtils.get((Object)bar, (String)"foo"));
        OwsUtilsTest.assertNull((Object)OwsUtils.get((Object)bar, (String)"foo.a"));
        foo.setA("abc");
        OwsUtilsTest.assertEquals((Object)"abc", (Object)OwsUtils.get((Object)bar, (String)"foo.a"));
        OwsUtils.set((Object)bar, (String)"foo.b", (Object)123);
        OwsUtilsTest.assertEquals((Object)123, (Object)OwsUtils.get((Object)bar, (String)"foo.b"));
    }

    class Bar {
        Foo foo;
        Double d;

        Bar() {
        }

        public Foo getFoo() {
            return this.foo;
        }

        public void setFoo(Foo foo) {
            this.foo = foo;
        }

        public Double getD() {
            return this.d;
        }

        public void setD(Double d) {
            this.d = d;
        }
    }

    class Foo {
        String a;
        Integer b;
        float c;

        Foo() {
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public Integer getB() {
            return this.b;
        }

        public void setB(Integer b) {
            this.b = b;
        }

        public float getC() {
            return this.c;
        }

        public void setC(float c) {
            this.c = c;
        }
    }
}

