/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class GeoServerResourceLoader
extends DefaultResourceLoader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    Set searchLocations = new TreeSet();
    File baseDirectory;

    public GeoServerResourceLoader() {
    }

    public GeoServerResourceLoader(File baseDirectory) {
        this();
        this.baseDirectory = baseDirectory;
        this.setSearchLocations(Collections.EMPTY_SET);
    }

    public void addSearchLocation(File searchLocation) {
        this.searchLocations.add(searchLocation);
    }

    public void setSearchLocations(Set searchLocations) {
        this.searchLocations = new HashSet(searchLocations);
        if (this.baseDirectory != null) {
            this.searchLocations.add(this.baseDirectory);
        }
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.searchLocations.add(baseDirectory);
    }

    public File find(String location) throws IOException {
        return this.find((File)null, location);
    }

    public File find(File parent, String location) throws IOException {
        Resource resource;
        File file;
        File file2 = file = parent != null ? new File(parent, location) : new File(location);
        if (file.exists()) {
            return file;
        }
        if (file.isAbsolute()) {
            return file.exists() ? file : null;
        }
        if (parent == null) {
            for (File base : this.searchLocations) {
                file = new File(base, location);
                try {
                    if (!file.exists()) continue;
                    return file;
                }
                catch (SecurityException e) {
                    LOGGER.warning("Failed attemp to check existance of " + file.getAbsolutePath());
                }
            }
        }
        if (parent == null && (resource = this.getResource(location)).exists()) {
            return resource.getFile();
        }
        return null;
    }

    public File find(String ... location) throws IOException {
        return this.find((File)null, location);
    }

    public File find(File parent, String ... location) throws IOException {
        return this.find(parent, this.concat(location));
    }

    String concat(String ... location) {
        StringBuffer loc = new StringBuffer();
        int i = 0;
        while (i < location.length) {
            loc.append(location[i]).append(File.separator);
            ++i;
        }
        loc.setLength(loc.length() - 1);
        return loc.toString();
    }

    public File findOrCreateDirectory(String ... location) throws IOException {
        return this.findOrCreateDirectory((File)null, location);
    }

    public File findOrCreateDirectory(File parent, String ... location) throws IOException {
        return this.findOrCreateDirectory(this.concat(location));
    }

    public File findOrCreateDirectory(String location) throws IOException {
        return this.findOrCreateDirectory((File)null, location);
    }

    public File findOrCreateDirectory(File parent, String location) throws IOException {
        File dir = this.find(parent, location);
        if (dir != null) {
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Location '" + location + "' specifies a file");
            }
            return dir;
        }
        return this.createDirectory(location);
    }

    public File createDirectory(String ... location) throws IOException {
        return this.createDirectory((File)null, location);
    }

    public File createDirectory(File parent, String ... location) throws IOException {
        return this.createDirectory(parent, this.concat(location));
    }

    public File createDirectory(String location) throws IOException {
        return this.createDirectory((File)null, location);
    }

    public File createDirectory(File parent, String location) throws IOException {
        File file = this.find(parent, location);
        if (file != null && !file.isDirectory()) {
            String msg = String.valueOf(location) + " already exists and is not directory";
            throw new IOException(msg);
        }
        File file2 = file = parent != null ? new File(parent, location) : new File(location);
        if (file.isAbsolute()) {
            file.mkdirs();
            return file;
        }
        if (parent == null) {
            if (this.baseDirectory == null) {
                String msg = "No base location set, could not create directory: " + location;
                throw new IOException(msg);
            }
            file = new File(this.baseDirectory, location);
            file.mkdirs();
            return file;
        }
        return null;
    }

    public File createFile(String ... location) throws IOException {
        return this.createFile(this.concat(location));
    }

    public File createFile(String location) throws IOException {
        return this.createFile((File)null, location);
    }

    public File createFile(File parent, String ... location) throws IOException {
        return this.createFile(parent, this.concat(location));
    }

    public File createFile(File parent, String location) throws IOException {
        File file = this.find(parent, location);
        if (file != null) {
            if (file.isDirectory()) {
                String msg = String.valueOf(location) + " already exists and is a directory";
                throw new IOException(msg);
            }
            return file;
        }
        File file2 = file = parent != null ? new File(parent, location) : new File(location);
        if (file.isAbsolute()) {
            file.createNewFile();
            return file;
        }
        if (parent == null) {
            if (this.baseDirectory == null) {
                String msg = "No base location set, could not create file: " + location;
                throw new IOException(msg);
            }
            file = new File(this.baseDirectory, location);
            file.createNewFile();
        }
        return file;
    }

    public void copyFromClassPath(String resource, String to) throws IOException {
        File target = new File(to);
        if (!target.isAbsolute()) {
            target = new File(this.getBaseDirectory(), to);
        }
        this.copyFromClassPath(resource, target);
    }

    public void copyFromClassPath(String resource, File target) throws IOException {
        this.copyFromClassPath(resource, target, null);
    }

    public void copyFromClassPath(String resource, File target, Class scope) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        byte[] buffer = new byte[4096];
        try {
            try {
                int read;
                is = scope == null ? Thread.currentThread().getContextClassLoader().getResourceAsStream(resource) : scope.getResourceAsStream(resource);
                os = new FileOutputStream(target);
                while ((read = is.read(buffer)) > 0) {
                    os.write(buffer, 0, read);
                }
            }
            catch (FileNotFoundException targetException) {
                throw new IOException("Can't write to file " + target.getAbsolutePath() + ". Check write permissions on target folder for user " + System.getProperty("user.name"));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error trying to copy logging configuration file", e);
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

