/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import org.easymock.EasyMock;
import org.geoserver.rest.DispatcherCallback;
import org.geoserver.test.GeoServerTestSupport;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RESTDispatcherCallbackTest
extends GeoServerTestSupport {
    DispatcherCallback callback;

    protected void setUpInternal() throws Exception {
        this.callback = (DispatcherCallback)EasyMock.createMock(DispatcherCallback.class);
        applicationContext.getBeanFactory().addBeanPostProcessor(new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if ("testCallback".equals(beanName)) {
                    return RESTDispatcherCallbackTest.this.callback;
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }
        });
        applicationContext.getBeanFactory().destroySingletons();
        applicationContext.getBeanFactory().preInstantiateSingletons();
    }

    public void testCallback() throws Exception {
        this.callback.init((Request)EasyMock.anyObject(), (Response)EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.dispatched((Request)EasyMock.anyObject(), (Response)EasyMock.anyObject(), (Restlet)EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.finished((Request)EasyMock.anyObject(), (Response)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.callback});
        this.getAsServletResponse("/rest/index.html");
        EasyMock.verify((Object[])new Object[]{this.callback});
    }

    public void testCallbackException() throws Exception {
        this.callback.init((Request)EasyMock.anyObject(), (Response)EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.dispatched((Request)EasyMock.anyObject(), (Response)EasyMock.anyObject(), (Restlet)EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.exception((Request)EasyMock.anyObject(), (Response)EasyMock.anyObject(), (Exception)EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.finished((Request)EasyMock.anyObject(), (Response)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.callback});
        this.getAsServletResponse("/rest/exception?code=400&message=error");
        EasyMock.verify((Object[])new Object[]{this.callback});
    }

    static class TestCallback
    implements DispatcherCallback {
        TestCallback() {
        }

        public void init(Request request, Response response) {
        }

        public void dispatched(Request request, Response response, Restlet restlet) {
        }

        public void exception(Request request, Response response, Exception error) {
        }

        public void finished(Request request, Response response) {
        }
    }
}

