/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.rest.MapResource;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.FreemarkerFormat;
import org.restlet.Context;
import org.restlet.Finder;
import org.restlet.Route;
import org.restlet.Router;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Resource;

class IndexRestlet
extends Finder {
    private Router myRouter;

    public IndexRestlet(Router r) {
        this.myRouter = r;
    }

    public IndexRestlet(Context con, Router router) {
        super(con);
        this.myRouter = router;
    }

    public Resource findTarget(Request req, Response resp) {
        IndexResource r = new IndexResource(this.getContext(), req, resp);
        r.init(this.getContext(), req, resp);
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexResource
    extends MapResource {
        public IndexResource(Context context, Request request, Response response) {
            super(context, request, response);
        }

        @Override
        protected List<DataFormat> createSupportedFormats(Request request, Response response) {
            ArrayList<DataFormat> l = new ArrayList<DataFormat>();
            l.add(new FreemarkerFormat("templates/index.ftl", ((Object)((Object)this)).getClass(), MediaType.TEXT_HTML));
            return l;
        }

        @Override
        public Map getMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("links", this.getLinkList());
            m.put("page", this.getPageInfo());
            return m;
        }

        private List getLinkList() {
            ArrayList<String> l = new ArrayList<String>();
            for (Route r : IndexRestlet.this.myRouter.getRoutes()) {
                String pattern = r.getTemplate().getPattern();
                if (pattern.contains("{") || pattern.length() <= 1) continue;
                l.add(pattern.substring(1));
            }
            return l;
        }
    }
}

