/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataUtilities;
import org.geotools.util.logging.Logging;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    private static final Logger LOGGER = Logging.getLogger(FileCleaner.class);
    private static final int DEFAULT_SIZE = 0xA00000;
    private static final FileCleaner FILE_CLEANER = new FileCleaner();
    private static final Set<String> FILES_PATH = Collections.synchronizedSet(new HashSet());
    private static final Map<String, Integer> FILE_ATTEMPTS_COUNTS = Collections.synchronizedMap(new HashMap());
    private static long DEFAULT_PERIOD = 5L;
    private static final int DEF_MAX_ATTEMPTS = 50;

    static {
        FILE_CLEANER.setMaxAttempts(100);
        FILE_CLEANER.setPeriod(30L);
        FILE_CLEANER.setPriority(1);
        FILE_CLEANER.start();
    }

    public static void copyChannel(int bufferSize, ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        IOUtils.inputNotNull(source, destination);
        if (!source.isOpen() || !destination.isOpen()) {
            throw new IllegalStateException("Source and destination channels must be open.");
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        while (source.read(buffer) != -1) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                destination.write(buffer);
            }
            buffer.clear();
        }
    }

    public static void copyFileChannel(int bufferSize, FileChannel source, FileChannel destination) throws IOException {
        IOUtils.inputNotNull(source, destination);
        if (!source.isOpen() || !destination.isOpen()) {
            throw new IllegalStateException("Source and destination channels must be open.");
        }
        FileLock lock = null;
        try {
            lock = destination.lock();
            long sourceSize = source.size();
            long pos = 0L;
            while (pos < sourceSize) {
                long remaining = sourceSize - pos;
                int mappedZoneSize = remaining >= (long)bufferSize ? bufferSize : (int)remaining;
                destination.transferFrom(source, pos, mappedZoneSize);
                pos += (long)mappedZoneSize;
            }
        }
        finally {
            block11: {
                if (lock != null) {
                    try {
                        lock.release();
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.INFO)) break block11;
                        LOGGER.log(Level.INFO, t.getLocalizedMessage(), t);
                    }
                }
            }
        }
    }

    public static void closeQuietly(Channel channel) throws IOException {
        IOUtils.inputNotNull(channel);
        if (channel.isOpen()) {
            channel.close();
        }
    }

    private static void inputNotNull(Object ... oList) {
        Object[] objectArray = oList;
        int n = oList.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == null) {
                throw new NullPointerException("Input objects cannot be null");
            }
            ++n2;
        }
    }

    public static void copyFile(File sourceFile, File destinationFile) throws IOException {
        IOUtils.copyFile(sourceFile, destinationFile, 0xA00000);
    }

    public static void copyFile(File sourceFile, File destinationFile, int size) throws IOException {
        IOUtils.inputNotNull(sourceFile, destinationFile);
        if (!(sourceFile.exists() && sourceFile.canRead() && sourceFile.isFile())) {
            throw new IllegalStateException("Source is not in a legal state.");
        }
        if (!destinationFile.exists()) {
            destinationFile.createNewFile();
        }
        if (destinationFile.getAbsolutePath().equalsIgnoreCase(sourceFile.getAbsolutePath())) {
            throw new IllegalArgumentException("Cannot copy a file on itself");
        }
        FileChannel source = null;
        FileChannel destination = null;
        source = new RandomAccessFile(sourceFile, "r").getChannel();
        destination = new RandomAccessFile(destinationFile, "rw").getChannel();
        try {
            IOUtils.copyFileChannel(size, source, destination);
        }
        finally {
            try {
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (Throwable t) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.log(Level.INFO, t.getLocalizedMessage(), t);
                        }
                    }
                }
            }
            finally {
                block28: {
                    if (destination != null) {
                        try {
                            destination.close();
                        }
                        catch (Throwable t) {
                            if (!LOGGER.isLoggable(Level.INFO)) break block28;
                            LOGGER.log(Level.INFO, t.getLocalizedMessage(), t);
                        }
                    }
                }
            }
        }
    }

    public static boolean deleteDirectory(File sourceDirectory, FilenameFilter filter, boolean recursive, boolean deleteItself) {
        File[] files;
        IOUtils.inputNotNull(sourceDirectory, filter);
        if (!(sourceDirectory.exists() && sourceDirectory.canRead() && sourceDirectory.isDirectory())) {
            throw new IllegalStateException("Source is not in a legal state.");
        }
        File[] fileArray = files = filter != null ? sourceDirectory.listFiles(filter) : sourceDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (recursive) {
                    IOUtils.deleteDirectory(file, filter, recursive, deleteItself);
                }
            } else if (!file.delete()) {
                return false;
            }
            ++n2;
        }
        return deleteItself ? sourceDirectory.delete() : true;
    }

    public static void deleteFile(File file) {
        IOUtils.inputNotNull(file);
        if (!(file.exists() && file.canRead() && file.isFile())) {
            throw new IllegalStateException("Source is not in a legal state.");
        }
        if (file.delete()) {
            return;
        }
        FILE_CLEANER.addFile(file);
    }

    public static FileChannel getInputChannel(File source) throws IOException {
        IOUtils.inputNotNull(source);
        if (!(source.exists() && source.canRead() && source.isDirectory())) {
            throw new IllegalStateException("Source is not in a legal state.");
        }
        FileChannel channel = null;
        while (channel == null) {
            try {
                channel = new FileInputStream(source).getChannel();
            }
            catch (Exception e) {
                channel = null;
            }
        }
        return channel;
    }

    public static FileChannel getOuputChannel(File file) throws IOException {
        IOUtils.inputNotNull(file);
        return new RandomAccessFile(file, "rw").getChannel();
    }

    public static void moveFileTo(File source, File destDir, boolean removeInputFile) throws IOException {
        IOUtils.inputNotNull(source, destDir);
        if (!source.exists() || !source.canRead() || source.isDirectory()) {
            throw new IllegalStateException("Source is not in a legal state.");
        }
        if (!(destDir.exists() && destDir.canWrite() && destDir.isDirectory())) {
            throw new IllegalStateException("Source is not in a legal state.");
        }
        if (destDir.getAbsolutePath().equalsIgnoreCase(source.getParentFile().getAbsolutePath())) {
            return;
        }
        IOUtils.copyFile(source, new File(destDir, source.getName()));
        if (removeInputFile) {
            FILE_CLEANER.addFile(source);
        }
    }

    public static File URLToFile(URL fileURL) {
        IOUtils.inputNotNull(fileURL);
        try {
            File retFile = DataUtilities.urlToFile((URL)fileURL);
            return retFile;
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
            }
            return null;
        }
    }

    public static void copyStream(InputStream sourceStream, OutputStream destinationStream, boolean closeInput, boolean closeOutput) throws IOException {
        IOUtils.copyStream(sourceStream, destinationStream, 0xA00000, closeInput, closeOutput);
    }

    public static void copyStream(InputStream sourceStream, OutputStream destinationStream, int size, boolean closeInput, boolean closeOutput) throws IOException {
        IOUtils.inputNotNull(sourceStream, destinationStream);
        byte[] buf = new byte[size];
        int n = -1;
        try {
            while (-1 != (n = sourceStream.read(buf))) {
                destinationStream.write(buf, 0, n);
                destinationStream.flush();
            }
        }
        finally {
            try {
                destinationStream.flush();
            }
            finally {
                try {
                    if (closeOutput) {
                        destinationStream.close();
                    }
                }
                finally {
                    if (closeInput) {
                        sourceStream.close();
                    }
                }
            }
        }
    }

    public static String getStringFromStream(InputStream inputStream) throws IOException {
        IOUtils.inputNotNull(inputStream);
        InputStreamReader inReq = new InputStreamReader(inputStream);
        return IOUtils.getStringFromReader(inReq);
    }

    public static String getStringFromReader(Reader inputReader) throws IOException {
        int len;
        IOUtils.inputNotNull(inputReader);
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        while ((len = inputReader.read(buffer)) >= 0) {
            char[] read = new char[len];
            System.arraycopy(buffer, 0, read, 0, len);
            sb.append(read);
        }
        return sb.toString();
    }

    public static String getStringFromStreamSource(StreamSource src) throws IOException {
        IOUtils.inputNotNull(src);
        InputStream inputStream = src.getInputStream();
        if (inputStream != null) {
            return IOUtils.getStringFromStream(inputStream);
        }
        Reader r = src.getReader();
        return IOUtils.getStringFromReader(r);
    }

    public static void inflate(ZipFile archive, File outputDirectory, String fileName) throws IOException, FileNotFoundException {
        Enumeration<? extends ZipEntry> entries = archive.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.isDirectory()) {
                    String name = entry.getName();
                    String ext = FilenameUtils.getExtension((String)name);
                    BufferedInputStream in = new BufferedInputStream(archive.getInputStream(entry));
                    File outFile = new File(outputDirectory, fileName != null ? fileName + "." + ext : name);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
                    IOUtils.copyStream(in, out, true, true);
                    continue;
                }
                new File(outputDirectory, entry.getName()).mkdirs();
            }
        }
        finally {
            block10: {
                try {
                    archive.close();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block10;
                    LOGGER.isLoggable(Level.FINE);
                }
            }
        }
    }

    private IOUtils() {
    }

    public static final class FileCleaner
    extends Thread {
        private int maxAttempts = 50;
        private volatile long period = IOUtils.access$0();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFile(File fileToDelete) {
            if (!fileToDelete.exists()) {
                return;
            }
            Set set = FILES_PATH;
            synchronized (set) {
                Map map = FILE_ATTEMPTS_COUNTS;
                synchronized (map) {
                    if (!FILES_PATH.contains(fileToDelete.getAbsolutePath())) {
                        FILES_PATH.add(fileToDelete.getAbsolutePath());
                        FILE_ATTEMPTS_COUNTS.put(fileToDelete.getAbsolutePath(), new Integer(0));
                    }
                }
            }
        }

        public FileCleaner() {
            this(DEFAULT_PERIOD, 2, 50);
        }

        public FileCleaner(long period, int priority, int maxattempts) {
            this.period = period;
            this.setName("FileCleaner");
            this.setPriority(priority);
            this.setDaemon(true);
            this.maxAttempts = maxattempts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Set set = FILES_PATH;
                        synchronized (set) {
                            Map map = FILE_ATTEMPTS_COUNTS;
                            synchronized (map) {
                                Iterator it = FILES_PATH.iterator();
                                while (it.hasNext()) {
                                    String sFile = (String)it.next();
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.info("Trying to remove file " + sFile);
                                    }
                                    int attempts = (Integer)FILE_ATTEMPTS_COUNTS.get(sFile);
                                    if (!new File(sFile).exists()) {
                                        it.remove();
                                        FILE_ATTEMPTS_COUNTS.remove(sFile);
                                        continue;
                                    }
                                    if (new File(sFile).delete()) {
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            LOGGER.info("Successfully removed file " + sFile);
                                        }
                                        it.remove();
                                        FILE_ATTEMPTS_COUNTS.remove(sFile);
                                        continue;
                                    }
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.info("Unable to  remove file " + sFile);
                                    }
                                    if (this.maxAttempts < ++attempts) {
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            LOGGER.info("Dropping file " + sFile);
                                        }
                                        it.remove();
                                        FILE_ATTEMPTS_COUNTS.remove(sFile);
                                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                                        LOGGER.warning("Unable to delete file " + sFile);
                                        continue;
                                    }
                                    FILE_ATTEMPTS_COUNTS.remove(sFile);
                                    FILE_ATTEMPTS_COUNTS.put(sFile, new Integer(attempts));
                                    Runtime.getRuntime().gc();
                                    Runtime.getRuntime().gc();
                                    Runtime.getRuntime().gc();
                                    Runtime.getRuntime().gc();
                                    Runtime.getRuntime().gc();
                                    Runtime.getRuntime().gc();
                                    System.runFinalization();
                                    System.runFinalization();
                                    System.runFinalization();
                                    System.runFinalization();
                                    System.runFinalization();
                                    System.runFinalization();
                                }
                            }
                        }
                        Thread.sleep(this.period * 1000L);
                    }
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.log(Level.INFO, t.getLocalizedMessage(), t);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMaxAttempts() {
            Set set = FILES_PATH;
            synchronized (set) {
                Map map = FILE_ATTEMPTS_COUNTS;
                synchronized (map) {
                    return this.maxAttempts;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMaxAttempts(int maxAttempts) {
            Set set = FILES_PATH;
            synchronized (set) {
                Map map = FILE_ATTEMPTS_COUNTS;
                synchronized (map) {
                    this.maxAttempts = maxAttempts;
                }
            }
        }

        public long getPeriod() {
            return this.period;
        }

        public void setPeriod(long period) {
            this.period = period;
        }
    }
}

