/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.MapJSONFormat;
import org.geoserver.rest.format.MapXMLFormat;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.OneTimeSetupTest;

public class FormatTest
extends GeoServerTestSupport {
    static List formats;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new FormatTest());
    }

    public void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        formats = new ArrayList();
        formats.add(new MapXMLFormat());
        formats.add(new MapJSONFormat());
    }

    public void testFormatMap() {
        Iterator it = formats.iterator();
        while (it.hasNext()) {
            try {
                DataFormat format = (DataFormat)it.next();
                HashMap<String, String> input = new HashMap<String, String>();
                input.put("Hello", "Goodbye");
                Map result = (Map)format.toObject(format.toRepresentation(input));
                FormatTest.assertEquals((int)result.size(), (int)input.size());
                for (Map.Entry ent : input.entrySet()) {
                    FormatTest.assertEquals(result.get(ent.getKey()), ent.getValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testFormatList() {
        Iterator it = formats.iterator();
        while (it.hasNext()) {
            try {
                DataFormat format = (DataFormat)it.next();
                ArrayList<String> input = new ArrayList<String>();
                input.add("Hello");
                List result = (List)format.toObject(format.toRepresentation(input));
                FormatTest.assertEquals((int)result.size(), (int)input.size());
                int i = 0;
                while (i < result.size()) {
                    FormatTest.assertEquals(input.get(i), result.get(i));
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dontTestFormatScalar() {
        for (DataFormat format : formats) {
            String input = "Hello";
            String result = (String)format.toObject(format.toRepresentation((Object)input));
            FormatTest.assertEquals((String)input, (String)result);
        }
    }
}

