/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geotools.data.DataStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataStoreTest
extends CatalogRESTTestSupport {
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores.xml");
        DataStoreTest.assertEquals((int)this.catalog.getStoresByWorkspace("sf", DataStoreInfo.class).size(), (int)dom.getElementsByTagName("dataStore").getLength());
    }

    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/datastores.json");
        DataStoreTest.assertTrue((boolean)(json instanceof JSONObject));
        Object datastores = ((JSONObject)json).getJSONObject("dataStores").get("dataStore");
        DataStoreTest.assertNotNull((Object)datastores);
        if (datastores instanceof JSONArray) {
            DataStoreTest.assertEquals((int)this.catalog.getDataStoresByWorkspace("sf").size(), (int)((JSONArray)datastores).size());
        } else {
            DataStoreTest.assertEquals((int)1, (int)this.catalog.getDataStoresByWorkspace("sf").size());
        }
    }

    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores.html");
        List datastores = this.catalog.getDataStoresByWorkspace("sf");
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        DataStoreTest.assertEquals((int)datastores.size(), (int)links.getLength());
        for (int i = 0; i < datastores.size(); ++i) {
            DataStoreInfo ds = (DataStoreInfo)datastores.get(i);
            Element link = (Element)links.item(i);
            DataStoreTest.assertTrue((boolean)link.getAttribute("href").endsWith(ds.getName() + ".html"));
        }
    }

    public void testPutAllUnauthorized() throws Exception {
        DataStoreTest.assertEquals((int)405, (int)this.putAsServletResponse("/rest/workspaces/sf/datastores").getStatusCode());
    }

    public void testDeleteAllUnauthorized() throws Exception {
        DataStoreTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores").getStatusCode());
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        DataStoreTest.assertEquals((String)"dataStore", (String)dom.getDocumentElement().getNodeName());
        DataStoreTest.assertEquals((String)"sf", (String)this.xp.evaluate("/dataStore/name", dom));
        DataStoreTest.assertEquals((String)"sf", (String)this.xp.evaluate("/dataStore/workspace/name", dom));
        XMLAssert.assertXpathExists((String)"/dataStore/connectionParameters", (Document)dom);
    }

    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.html");
        DataStoreInfo ds = this.catalog.getDataStoreByName("sf");
        List featureTypes = this.catalog.getFeatureTypesByDataStore(ds);
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        DataStoreTest.assertEquals((int)featureTypes.size(), (int)links.getLength());
        for (int i = 0; i < featureTypes.size(); ++i) {
            FeatureTypeInfo ft = (FeatureTypeInfo)featureTypes.get(i);
            Element link = (Element)links.item(i);
            DataStoreTest.assertTrue((boolean)link.getAttribute("href").endsWith(ft.getName() + ".html"));
        }
    }

    File setupNewDataStore() throws Exception {
        Properties props = new Properties();
        props.put("_", "name:StringpointProperty:Point");
        props.put("NewDataStore.0", "'zero'|POINT(0 0)");
        props.put("NewDataStore.1", "'one'|POINT(1 1)");
        File dir = new File("./target/nds");
        dir.mkdir();
        File file = new File(dir, "newDataStore.properties");
        file.deleteOnExit();
        dir.deleteOnExit();
        props.store(new FileOutputStream(file), null);
        return dir;
    }

    public void testPostAsXML() throws Exception {
        File dir = this.setupNewDataStore();
        String xml = "<dataStore><name>newDataStore</name><connectionParameters><namespace><string>sf</string></namespace><directory><string>" + dir.getAbsolutePath() + "</string>" + "</directory>" + "</connectionParameters>" + "<workspace>sf</workspace>" + "</dataStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores", xml, "text/xml");
        DataStoreTest.assertEquals((int)201, (int)response.getStatusCode());
        DataStoreTest.assertNotNull((Object)response.getHeader("Location"));
        DataStoreTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/datastores/newDataStore"));
        DataStoreInfo newDataStore = this.catalog.getDataStoreByName("newDataStore");
        DataStoreTest.assertNotNull((Object)newDataStore);
        DataStore ds = (DataStore)newDataStore.getDataStore(null);
        DataStoreTest.assertNotNull((Object)ds);
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/datastores/sf.json");
        JSONObject dataStore = ((JSONObject)json).getJSONObject("dataStore");
        DataStoreTest.assertNotNull((Object)dataStore);
        DataStoreTest.assertEquals((Object)"sf", (Object)dataStore.get("name"));
        DataStoreTest.assertEquals((Object)"sf", (Object)dataStore.getJSONObject("workspace").get("name"));
        DataStoreTest.assertNotNull((Object)dataStore.get("connectionParameters"));
    }

    public void testPostAsJSON() throws Exception {
        File dir = this.setupNewDataStore();
        String json = "{'dataStore':{'connectionParameters': {'namespace': {'string':'sf'},'directory': {'string':'" + dir.getAbsolutePath().replace('\\', '/') + "'}" + "}," + "'workspace':'sf'," + "'name':'newDataStore'," + "}" + "}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores", json, "text/json");
        DataStoreTest.assertEquals((int)201, (int)response.getStatusCode());
        DataStoreTest.assertNotNull((Object)response.getHeader("Location"));
        DataStoreTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/datastores/newDataStore"));
        DataStoreInfo newDataStore = this.catalog.getDataStoreByName("newDataStore");
        DataStoreTest.assertNotNull((Object)newDataStore);
        DataStore ds = (DataStore)newDataStore.getDataStore(null);
        DataStoreTest.assertNotNull((Object)ds);
    }

    public void testPostToResource() throws Exception {
        String xml = "<dataStore><name>sf</name><enabled>false</enabled></dataStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        DataStoreTest.assertEquals((int)405, (int)response.getStatusCode());
    }

    public void testPut() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/dataStore/enabled", (Document)dom);
        String xml = "<dataStore><name>sf</name><enabled>false</enabled></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        DataStoreTest.assertEquals((int)200, (int)response.getStatusCode());
        dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/dataStore/enabled", (Document)dom);
        DataStoreTest.assertFalse((boolean)this.catalog.getDataStoreByName("sf", "sf").isEnabled());
    }

    public void testPut2() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//dataStore/connectionParameters/*)", (Document)dom);
        String xml = "<dataStore><name>sf</name><connectionParameters><one><string>1</string></one><two><string>2</string></two></connectionParameters></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        DataStoreTest.assertEquals((int)200, (int)response.getStatusCode());
        DataStoreInfo ds = this.catalog.getDataStoreByName("sf", "sf");
        DataStoreTest.assertEquals((int)2, (int)ds.getConnectionParameters().size());
        DataStoreTest.assertTrue((boolean)ds.getConnectionParameters().containsKey("one"));
        DataStoreTest.assertTrue((boolean)ds.getConnectionParameters().containsKey("two"));
    }

    public void testPutNonExistant() throws Exception {
        String xml = "<dataStore><name>changed</name></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/nonExistant", xml, "text/xml");
        DataStoreTest.assertEquals((int)404, (int)response.getStatusCode());
    }

    public void testDeleteNonExistant() throws Exception {
        DataStoreTest.assertEquals((int)404, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/nonExistant").getStatusCode());
    }

    public void testDelete() throws Exception {
        File dir = this.setupNewDataStore();
        String xml = "<dataStore><name>newDataStore</name><connectionParameters><entry><string>namespace</string><string>sf</string></entry><entry><string>directory</string><string>" + dir.getAbsolutePath() + "</string>" + "</entry>" + "</connectionParameters>" + "<workspace>sf</workspace>" + "</dataStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores", xml, "text/xml");
        DataStoreTest.assertEquals((int)201, (int)response.getStatusCode());
        DataStoreTest.assertNotNull((Object)this.catalog.getDataStoreByName("sf", "newDataStore"));
        DataStoreTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/newDataStore").getStatusCode());
        DataStoreTest.assertNull((Object)this.catalog.getDataStoreByName("sf", "newDataStore"));
    }

    public void testDeleteNonEmptyForbidden() throws Exception {
        DataStoreTest.assertEquals((int)403, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf").getStatusCode());
    }

    public void testDeleteRecursive() throws Exception {
        DataStoreTest.assertNotNull((Object)this.catalog.getDataStoreByName("sf", "sf"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf?recurse=true");
        DataStoreTest.assertEquals((int)200, (int)response.getStatusCode());
        DataStoreTest.assertNull((Object)this.catalog.getDataStoreByName("sf", "sf"));
        for (FeatureTypeInfo ft : this.catalog.getFeatureTypes()) {
            if (!ft.getStore().getName().equals("sf")) continue;
            DataStoreTest.fail();
        }
    }

    public void testPutNameChangeForbidden() throws Exception {
        String xml = "<dataStore><name>newName</name></dataStore>";
        DataStoreTest.assertEquals((int)403, (int)this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml").getStatusCode());
    }

    public void testPutWorkspaceChangeForbidden() throws Exception {
        String xml = "<dataStore><workspace>gs</workspace></dataStore>";
        DataStoreTest.assertEquals((int)403, (int)this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml").getStatusCode());
    }
}

