/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geoserver.catalog.rest.SLDFormat;
import org.geoserver.catalog.rest.StyleResource;
import org.geotools.styling.Style;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StyleTest
extends CatalogRESTTestSupport {
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/styles.xml");
        List styles = this.catalog.getStyles();
        XMLAssert.assertXpathEvaluatesTo((String)("" + styles.size()), (String)"count(//style)", (Document)dom);
    }

    public void testGetAllASJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/styles.json");
        List styles = this.catalog.getStyles();
        StyleTest.assertEquals((int)styles.size(), (int)((JSONObject)json).getJSONObject("styles").getJSONArray("style").size());
    }

    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/styles.html");
        List styles = this.catalog.getStyles();
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        for (int i = 0; i < styles.size(); ++i) {
            StyleInfo s = (StyleInfo)styles.get(i);
            Element link = (Element)links.item(i);
            StyleTest.assertTrue((boolean)link.getAttribute("href").endsWith(s.getName() + ".html"));
        }
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/styles/Ponds.xml");
        StyleTest.assertEquals((String)"style", (String)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"Ponds", (String)"/style/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Ponds.sld", (String)"/style/filename", (Document)dom);
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/styles/Ponds.json");
        JSONObject style = ((JSONObject)json).getJSONObject("style");
        StyleTest.assertEquals((Object)"Ponds", (Object)style.get("name"));
        StyleTest.assertEquals((Object)"Ponds.sld", (Object)style.get("filename"));
    }

    public void testGetAsSLD() throws Exception {
        Document dom = this.getAsDOM("/rest/styles/Ponds.sld");
        StyleTest.assertEquals((String)"sld:StyledLayerDescriptor", (String)dom.getDocumentElement().getNodeName());
    }

    String newSLDXML() {
        return "<sld:StyledLayerDescriptor xmlns:sld='http://www.opengis.net/sld'><sld:NamedLayer><sld:Name>foo</sld:Name><sld:UserStyle><sld:Name>foo</sld:Name><sld:FeatureTypeStyle><sld:Name>foo</sld:Name></sld:FeatureTypeStyle></sld:UserStyle></sld:NamedLayer></sld:StyledLayerDescriptor>";
    }

    public void testPostAsSLD() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml, StyleResource.MEDIATYPE_SLD.toString());
        StyleTest.assertEquals((int)201, (int)response.getStatusCode());
        StyleTest.assertNotNull((Object)response.getHeader("Location"));
        StyleTest.assertTrue((boolean)response.getHeader("Location").endsWith("/styles/foo"));
        StyleTest.assertNotNull((Object)this.catalog.getStyleByName("foo"));
    }

    public void testPostAsSLDWithName() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=bar", xml, StyleResource.MEDIATYPE_SLD.toString());
        StyleTest.assertEquals((int)201, (int)response.getStatusCode());
        StyleTest.assertNotNull((Object)response.getHeader("Location"));
        StyleTest.assertTrue((boolean)response.getHeader("Location").endsWith("/styles/bar"));
        StyleTest.assertNotNull((Object)this.catalog.getStyleByName("bar"));
    }

    public void testPut() throws Exception {
        StyleInfo style = this.catalog.getStyleByName("Ponds");
        StyleTest.assertEquals((String)"Ponds.sld", (String)style.getFilename());
        String xml = "<style><name>Ponds</name><filename>Forests.sld</filename></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds", xml.getBytes(), "text/xml");
        StyleTest.assertEquals((int)200, (int)response.getStatusCode());
        style = this.catalog.getStyleByName("Ponds");
        StyleTest.assertEquals((String)"Forests.sld", (String)style.getFilename());
    }

    public void testPutAsSLD() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds", xml, StyleResource.MEDIATYPE_SLD.toString());
        StyleTest.assertEquals((int)200, (int)response.getStatusCode());
        Style s = this.catalog.getStyleByName("Ponds").getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new SLDFormat().write((Object)s, (OutputStream)out);
        xml = new String(out.toByteArray());
        StyleTest.assertTrue((boolean)xml.contains("<sld:Name>foo</sld:Name>"));
    }

    public void testDelete() throws Exception {
        String xml = "<style><name>dummy</name><filename>dummy.sld</filename></style>";
        this.post("/rest/styles", xml, "text/xml");
        StyleTest.assertNotNull((Object)this.catalog.getStyleByName("dummy"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/styles/dummy");
        StyleTest.assertEquals((int)200, (int)response.getStatusCode());
        StyleTest.assertNull((Object)this.catalog.getStyleByName("dummy"));
    }

    public void testDeleteWithLayerReference() throws Exception {
        StyleTest.assertNotNull((Object)this.catalog.getStyleByName("Ponds"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/styles/Ponds");
        StyleTest.assertEquals((int)403, (int)response.getStatusCode());
        StyleTest.assertNotNull((Object)this.catalog.getStyleByName("Ponds"));
    }

    public void testDeleteWithoutPurge() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml, StyleResource.MEDIATYPE_SLD.toString());
        StyleTest.assertNotNull((Object)this.catalog.getStyleByName("foo"));
        StyleTest.assertTrue((boolean)new File(this.getDataDirectory().findStyleDir(), "foo.sld").exists());
        response = this.deleteAsServletResponse("/rest/styles/foo");
        StyleTest.assertEquals((int)200, (int)response.getStatusCode());
        StyleTest.assertTrue((boolean)new File(this.getDataDirectory().findStyleDir(), "foo.sld").exists());
    }

    public void testDeleteWithPurge() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml, StyleResource.MEDIATYPE_SLD.toString());
        StyleTest.assertNotNull((Object)this.catalog.getStyleByName("foo"));
        StyleTest.assertTrue((boolean)new File(this.getDataDirectory().findStyleDir(), "foo.sld").exists());
        response = this.deleteAsServletResponse("/rest/styles/foo?purge=true");
        StyleTest.assertEquals((int)200, (int)response.getStatusCode());
        StyleTest.assertFalse((boolean)new File(this.getDataDirectory().findStyleDir(), "foo.sld").exists());
    }

    public void testGetAllByLayer() throws Exception {
        Document dom = this.getAsDOM("/rest/layers/cite:BasicPolygons/styles.xml");
        LayerInfo layer = this.catalog.getLayerByName("cite:BasicPolygons");
        XMLAssert.assertXpathEvaluatesTo((String)(layer.getStyles().size() + ""), (String)"count(//style)", (Document)dom);
    }

    public void testPostByLayer() throws Exception {
        LayerInfo l = this.catalog.getLayerByName("cite:BasicPolygons");
        int nstyles = l.getStyles().size();
        String xml = "<style><name>Ponds</name></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layers/cite:BasicPolygons/styles", xml, "text/xml");
        StyleTest.assertEquals((int)201, (int)response.getStatusCode());
        LayerInfo l2 = this.catalog.getLayerByName("cite:BasicPolygons");
        StyleTest.assertEquals((int)(nstyles + 1), (int)l2.getStyles().size());
        StyleTest.assertTrue((boolean)l2.getStyles().contains(this.catalog.getStyleByName("Ponds")));
    }

    public void testPostByLayerWithDefault() throws Exception {
        LayerInfo l = this.catalog.getLayerByName("cite:BasicPolygons");
        int nstyles = l.getStyles().size();
        String xml = "<style><name>Ponds</name></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layers/cite:BasicPolygons/styles?default=true", xml, "text/xml");
        StyleTest.assertEquals((int)201, (int)response.getStatusCode());
        LayerInfo l2 = this.catalog.getLayerByName("cite:BasicPolygons");
        StyleTest.assertEquals((int)(nstyles + 1), (int)l2.getStyles().size());
        StyleTest.assertEquals((Object)this.catalog.getStyleByName("Ponds"), (Object)l2.getDefaultStyle());
    }

    public void testPostByLayerExistingWithDefault() throws Exception {
        this.testPostByLayer();
        LayerInfo l = this.catalog.getLayerByName("cite:BasicPolygons");
        int nstyles = l.getStyles().size();
        String xml = "<style><name>Ponds</name></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layers/cite:BasicPolygons/styles?default=true", xml, "text/xml");
        StyleTest.assertEquals((int)201, (int)response.getStatusCode());
        LayerInfo l2 = this.catalog.getLayerByName("cite:BasicPolygons");
        StyleTest.assertEquals((int)nstyles, (int)l2.getStyles().size());
        StyleTest.assertEquals((Object)this.catalog.getStyleByName("Ponds"), (Object)l2.getDefaultStyle());
    }
}

