/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.FeatureType;
import org.w3c.dom.Document;

public class FeatureTypeTest
extends CatalogRESTTestSupport {
    public void testGetAllByWorkspace() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/featuretypes.xml");
        FeatureTypeTest.assertEquals((int)this.catalog.getFeatureTypesByNamespace(this.catalog.getNamespaceByPrefix("sf")).size(), (int)dom.getElementsByTagName("featureType").getLength());
    }

    void addPropertyDataStore(boolean configureFeatureType) throws Exception {
        ByteArrayOutputStream zbytes = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(zbytes);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bytes));
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("pdsa.0='zero'|POINT(0 0)\n");
        writer.write("pdsa.1='one'|POINT(1 1)\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("pdsa.properties"));
        zout.write(bytes.toByteArray());
        bytes.reset();
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("pdsb.0='two'|POINT(2 2)\n");
        writer.write("pdsb.1='trhee'|POINT(3 3)\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("pdsb.properties"));
        zout.write(bytes.toByteArray());
        zout.flush();
        zout.close();
        String q = "configure=" + (configureFeatureType ? "all" : "none");
        this.put("/rest/workspaces/gs/datastores/pds/file.properties?" + q, zbytes.toByteArray(), "application/zip");
    }

    void addGeomlessPropertyDataStore(boolean configureFeatureType) throws Exception {
        ByteArrayOutputStream zbytes = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(zbytes);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bytes));
        writer.write("_=name:String,intProperty:Integer\n");
        writer.write("ngpdsa.0='zero'|0\n");
        writer.write("ngpdsa.1='one'|1\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("ngpdsa.properties"));
        zout.write(bytes.toByteArray());
        bytes.reset();
        writer.write("_=name:String,intProperty:Integer\n");
        writer.write("ngpdsb.0='two'|2\n");
        writer.write("ngpdsb.1='trhee'|3\n");
        writer.flush();
        zout.putNextEntry(new ZipEntry("ngpdsb.properties"));
        zout.write(bytes.toByteArray());
        zout.flush();
        zout.close();
        String q = "configure=" + (configureFeatureType ? "all" : "none");
        this.put("/rest/workspaces/gs/datastores/ngpds/file.properties?" + q, zbytes.toByteArray(), "application/zip");
    }

    public void testGetAllByDataStore() throws Exception {
        this.addPropertyDataStore(true);
        Document dom = this.getAsDOM("/rest/workspaces/gs/datastores/pds/featuretypes.xml");
        FeatureTypeTest.assertEquals((int)2, (int)dom.getElementsByTagName("featureType").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureType/name[text()='pdsa'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureType/name[text()='pdsb'])", (Document)dom);
    }

    public void testGetAllAvailable() throws Exception {
        this.addPropertyDataStore(false);
        Document dom = this.getAsDOM("/rest/workspaces/gs/datastores/pds/featuretypes.xml?list=available");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureTypeName[text()='pdsa'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//featureTypeName[text()='pdsb'])", (Document)dom);
    }

    public void testPutAllUnauthorized() throws Exception {
        FeatureTypeTest.assertEquals((int)405, (int)this.putAsServletResponse("/rest/workspaces/sf/datastores/sf/featuretypes").getStatusCode());
    }

    public void testDeleteAllUnauthorized() throws Exception {
        FeatureTypeTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf/featuretypes").getStatusCode());
    }

    public void testPostAsXML() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=sf:pdsa");
        FeatureTypeTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
        this.addPropertyDataStore(false);
        String xml = "<featureType><name>pdsa</name><nativeName>pdsa</nativeName><srs>EPSG:4326</srs><nativeCRS>EPSG:4326</nativeCRS><nativeBoundingBox><minx>0.0</minx><maxx>1.0</maxx><miny>0.0</miny><maxy>1.0</maxy><crs>EPSG:4326</crs></nativeBoundingBox><store>pds</store></featureType>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/datastores/pds/featuretypes/", xml, "text/xml");
        FeatureTypeTest.assertEquals((int)201, (int)response.getStatusCode());
        FeatureTypeTest.assertNotNull((Object)response.getHeader("Location"));
        FeatureTypeTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/datastores/pds/featuretypes/pdsa"));
        dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pdsa");
        FeatureTypeTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        FeatureTypeTest.assertEquals((int)2, (int)dom.getElementsByTagName("gs:pdsa").getLength());
    }

    public void testPostAsJSON() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=sf:pdsa");
        FeatureTypeTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
        this.addPropertyDataStore(false);
        String json = "{'featureType':{'name':'pdsa','nativeName':'pdsa','srs':'EPSG:4326','nativeBoundingBox':{'minx':0.0,'maxx':1.0,'miny':0.0,'maxy':1.0,'crs':'EPSG:4326'},'nativeCRS':'EPSG:4326','store':'pds'}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/datastores/pds/featuretypes/", json, "text/json");
        FeatureTypeTest.assertEquals((int)201, (int)response.getStatusCode());
        FeatureTypeTest.assertNotNull((Object)response.getHeader("Location"));
        FeatureTypeTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/datastores/pds/featuretypes/pdsa"));
        dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pdsa");
        FeatureTypeTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        FeatureTypeTest.assertEquals((int)2, (int)dom.getElementsByTagName("gs:pdsa").getLength());
    }

    public void testPostToResource() throws Exception {
        this.addPropertyDataStore(true);
        String xml = "<featureType><name>pdsa</name></featureType>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/datastores/pds/featuretypes/pdsa", xml, "text/xml");
        FeatureTypeTest.assertEquals((int)405, (int)response.getStatusCode());
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/featuretypes/PrimitiveGeoFeature.xml");
        FeatureTypeTest.assertEquals((String)"featureType", (String)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"PrimitiveGeoFeature", (String)"/featureType/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:4326", (String)"/featureType/srs", (Document)dom);
        FeatureTypeTest.assertEquals((String)CRS.decode((String)"EPSG:4326").toWKT(), (String)this.xp.evaluate("/featureType/nativeCRS", dom));
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        ReferencedEnvelope re = ft.getLatLonBoundingBox();
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(re.getMinX()), (String)"/featureType/latLonBoundingBox/minx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(re.getMaxX()), (String)"/featureType/latLonBoundingBox/maxx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(re.getMinY()), (String)"/featureType/latLonBoundingBox/miny", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(re.getMaxY()), (String)"/featureType/latLonBoundingBox/maxy", (Document)dom);
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/featuretypes/PrimitiveGeoFeature.json");
        JSONObject featureType = ((JSONObject)json).getJSONObject("featureType");
        FeatureTypeTest.assertNotNull((Object)featureType);
        FeatureTypeTest.assertEquals((Object)"PrimitiveGeoFeature", (Object)featureType.get("name"));
        FeatureTypeTest.assertEquals((Object)CRS.decode((String)"EPSG:4326").toWKT(), (Object)featureType.get("nativeCRS"));
        FeatureTypeTest.assertEquals((Object)"EPSG:4326", (Object)featureType.get("srs"));
    }

    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature.html");
    }

    public void testPut() throws Exception {
        String xml = "<featureType><title>new title</title></featureType>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature", xml, "text/xml");
        FeatureTypeTest.assertEquals((int)200, (int)response.getStatusCode());
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"new title", (String)"/featureType/title", (Document)dom);
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        FeatureTypeTest.assertEquals((String)"new title", (String)ft.getTitle());
    }

    public void testPutNonExistant() throws Exception {
        String xml = "<featureType><title>new title</title></featureType>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf/featuretypes/NonExistant", xml, "text/xml");
        FeatureTypeTest.assertEquals((int)404, (int)response.getStatusCode());
    }

    public void testDelete() throws Exception {
        FeatureTypeTest.assertNotNull((Object)this.catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"));
        for (LayerInfo l : this.catalog.getLayers((ResourceInfo)this.catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"))) {
            this.catalog.remove(l);
        }
        FeatureTypeTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature").getStatusCode());
        FeatureTypeTest.assertNull((Object)this.catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"));
    }

    public void testDeleteNonExistant() throws Exception {
        FeatureTypeTest.assertEquals((int)404, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf/featuretypes/NonExistant").getStatusCode());
    }

    public void testDeleteRecursive() throws Exception {
        FeatureTypeTest.assertNotNull((Object)this.catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"));
        FeatureTypeTest.assertNotNull((Object)this.catalog.getLayerByName("sf:PrimitiveGeoFeature"));
        FeatureTypeTest.assertEquals((int)403, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature").getStatusCode());
        FeatureTypeTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf/featuretypes/PrimitiveGeoFeature?recurse=true").getStatusCode());
        FeatureTypeTest.assertNull((Object)this.catalog.getFeatureTypeByName("sf", "PrimitiveGeoFeature"));
        FeatureTypeTest.assertNull((Object)this.catalog.getLayerByName("sf:PrimitiveGeoFeature"));
    }

    public void testPostGeometrylessFeatureType() throws Exception {
        this.addGeomlessPropertyDataStore(false);
        String xml = "<featureType><name>ngpdsa</name></featureType>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/datastores/ngpds/featuretypes", xml, "text/xml");
        FeatureTypeTest.assertEquals((int)201, (int)response.getStatusCode());
        FeatureTypeTest.assertNotNull((Object)response.getHeader("Location"));
        FeatureTypeTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/datastores/ngpds/featuretypes/ngpdsa"));
    }

    public void testCreateFeatureType() throws Exception {
        String xml = "<featureType>\n  <name>states</name>\n  <nativeName>states</nativeName>\n  <namespace>\n    <name>cite</name>\n  </namespace>\n  <title>USA Population</title>\n  <srs>EPSG:4326</srs>\n  <attributes>\n    <attribute>\n      <name>the_geom</name>\n      <binding>com.vividsolutions.jts.geom.MultiPolygon</binding>\n    </attribute>\n    <attribute>\n      <name>STATE_NAME</name>\n      <binding>java.lang.String</binding>\n      <length>25</length>\n    </attribute>\n    <attribute>\n      <name>LAND_KM</name>\n      <binding>java.lang.Double</binding>\n    </attribute>\n  </attributes>\n</featureType>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cite/datastores/default/featuretypes", xml, "text/xml");
        FeatureTypeTest.assertEquals((int)201, (int)response.getStatusCode());
        FeatureTypeTest.assertNotNull((Object)response.getHeader("Location"));
        FeatureTypeTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/cite/datastores/default/featuretypes/states"));
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName("cite", "states");
        FeatureTypeTest.assertNotNull((Object)ft);
        FeatureType schema = ft.getFeatureType();
        FeatureTypeTest.assertEquals((String)"states", (String)schema.getName().getLocalPart());
        FeatureTypeTest.assertEquals((String)this.catalog.getNamespaceByPrefix("cite").getURI(), (String)schema.getName().getNamespaceURI());
        FeatureTypeTest.assertEquals((int)3, (int)schema.getDescriptors().size());
        FeatureTypeTest.assertNotNull((Object)schema.getDescriptor("the_geom"));
        FeatureTypeTest.assertEquals(MultiPolygon.class, (Object)schema.getDescriptor("the_geom").getType().getBinding());
        FeatureTypeTest.assertNotNull((Object)schema.getDescriptor("LAND_KM"));
        FeatureTypeTest.assertEquals(Double.class, (Object)schema.getDescriptor("LAND_KM").getType().getBinding());
    }
}

