/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.ReflectiveXMLFormat;
import org.geotools.data.DataStore;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class AvailableFeatureTypeResource
extends AbstractCatalogResource {
    public AvailableFeatureTypeResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, FeatureTypeInfo.class, catalog);
    }

    protected Object handleObjectGet() {
        String datastore;
        String workspace = this.getAttribute("workspace");
        DataStoreInfo info = this.catalog.getDataStoreByName(workspace, datastore = this.getAttribute("datastore"));
        if (info == null) {
            throw new RestletException("No such datastore: " + datastore, Status.CLIENT_ERROR_NOT_FOUND);
        }
        ArrayList<String> available = new ArrayList<String>();
        try {
            String[] featureTypeNames;
            DataStore ds = (DataStore)info.getDataStore(null);
            String[] stringArray = featureTypeNames = ds.getTypeNames();
            int n = featureTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String featureTypeName = stringArray[n2];
                FeatureTypeInfo ftinfo = this.catalog.getFeatureTypeByDataStore(info, featureTypeName);
                if (ftinfo == null) {
                    available.add(featureTypeName);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RestletException("Could not load datastore: " + datastore, Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        return available;
    }

    protected ReflectiveXMLFormat createXMLFormat(Request request, Response response) {
        return new ReflectiveXMLFormat(){

            protected void write(Object data, OutputStream output) throws IOException {
                XStream xstream = new XStream();
                xstream.alias("featureTypeName", String.class);
                xstream.toXML(data, output);
            }
        };
    }

    public boolean allowPost() {
        return false;
    }

    protected String handleObjectPost(Object object) {
        return null;
    }

    protected void handleObjectPut(Object object) {
    }
}

