/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.util.HashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.CoverageStoreFileResource;
import org.geoserver.catalog.rest.DataStoreFileResource;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.rest.RestletException;
import org.opengis.coverage.grid.Format;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class StoreFileFinder
extends AbstractCatalogFinder {
    protected static HashMap<String, String> formatToCoverageStoreFormat = new HashMap();

    static {
        Format[] formatArray = CoverageStoreUtils.formats;
        int n = CoverageStoreUtils.formats.length;
        int n2 = 0;
        while (n2 < n) {
            Format format = formatArray[n2];
            formatToCoverageStoreFormat.put(format.getName().toLowerCase(), format.getName());
            ++n2;
        }
    }

    public StoreFileFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String format = this.getAttribute(request, "format");
        String datastore = this.getAttribute(request, "datastore");
        String coveragestore = this.getAttribute(request, "coveragestore");
        if (datastore != null) {
            return new DataStoreFileResource(request, response, format, this.catalog);
        }
        String coverageFormatName = formatToCoverageStoreFormat.get(format);
        if (coverageFormatName == null) {
            throw new RestletException("Unsupported format: " + format, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        Format coverageFormat = null;
        try {
            coverageFormat = CoverageStoreUtils.acquireFormat((String)coverageFormatName);
        }
        catch (Exception e) {
            throw new RestletException("Coveragestore format unavailable: " + coverageFormatName, Status.SERVER_ERROR_INTERNAL);
        }
        return new CoverageStoreFileResource(request, response, coverageFormat, this.catalog);
    }
}

