/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class GeoTIFFCoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final Set<String> FORMATS = new HashSet<String>(Arrays.asList("image/geotiff", "image/tiff;subtype=\"geotiff\""));
    private GridCoverage2D sourceCoverage;

    @Override
    public boolean canProduce(String outputFormat) {
        return outputFormat != null && (outputFormat.equalsIgnoreCase("geotiff") || FORMATS.contains(outputFormat.toLowerCase()));
    }

    @Override
    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.sourceCoverage = coverage;
    }

    @Override
    public String getMimeFormatFor(String outputFormat) {
        if (this.canProduce(outputFormat)) {
            return "image/geotiff";
        }
        return null;
    }

    @Override
    public String getContentType() {
        return "image/tiff";
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public String getContentDisposition() {
        return "attachment;filename=" + this.sourceCoverage.getName() + ".tiff";
    }

    @Override
    public String getFileExtension() {
        return "tiff";
    }

    @Override
    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.sourceCoverage == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        GeoTiffFormat format = new GeoTiffFormat();
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(2);
        wp.setCompressionType("LZW");
        wp.setCompressionQuality(0.75f);
        wp.setTilingMode(2);
        wp.setTiling(256, 256);
        ParameterValueGroup writerParams = format.getWriteParameters();
        writerParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        GridCoverageWriter writer = format.getWriter((Object)output);
        writer.write((GridCoverage)this.sourceCoverage, writerParams.values().toArray(new GeneralParameterValue[1]));
        writer.dispose();
        this.sourceCoverage.dispose(false);
        this.sourceCoverage = null;
    }
}

