/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.test;

import java.io.File;
import java.util.HashMap;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.wcs.test.CoverageTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class WCSTestSupport
extends CoverageTestSupport {
    protected static XpathEngine xpath;
    protected static final boolean IS_WINDOWS;
    protected static final Schema WCS10_GETCAPABILITIES_SCHEMA;
    protected static final Schema WCS10_GETCOVERAGE_SCHEMA;
    protected static final Schema WCS10_DESCRIBECOVERAGE_SCHEMA;

    static {
        SchemaFactory factory;
        try {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            WCS10_GETCAPABILITIES_SCHEMA = factory.newSchema(new File("./schemas/wcs/1.0.0/wcsCapabilities.xsd"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse the WCS 1.0.0 schemas", e);
        }
        try {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            WCS10_GETCOVERAGE_SCHEMA = factory.newSchema(new File("./schemas/wcs/1.0.0/getCoverage.xsd"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse the WCS 1.0.0 schemas", e);
        }
        try {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            WCS10_DESCRIBECOVERAGE_SCHEMA = factory.newSchema(new File("./schemas/wcs/1.0.0/describeCoverage.xsd"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse the WCS 1.0.0 schemas", e);
        }
        boolean windows = false;
        try {
            windows = System.getProperty("os.name").matches(".*Windows.*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_WINDOWS = windows;
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wcs", "http://www.opengis.net/wcs");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xpath = XMLUnit.newXpathEngine();
    }

    protected boolean isMemoryCleanRequired() {
        return IS_WINDOWS;
    }

    protected void checkOws11Exception(Document dom) throws Exception {
        WCSTestSupport.assertEquals((String)"ServiceExceptionReport", (String)dom.getFirstChild().getNodeName());
        WCSTestSupport.assertEquals((String)"1.2.0", (String)dom.getFirstChild().getAttributes().getNamedItem("version").getNodeValue());
        XMLAssert.assertXpathEvaluatesTo((String)"1.2.0", (String)"/ServiceExceptionReport/@version", (Document)dom);
        Node root = xpath.getMatchingNodes("/ServiceExceptionReport", dom).item(0);
        WCSTestSupport.assertNotNull((Object)root);
    }
}

