/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.wcs.AbstractGetCoverageTest;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.Filter;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.SpringSecurityException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.vfny.geoserver.wcs.WcsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAccessManagerWCSTest
extends AbstractGetCoverageTest {
    protected String[] getSpringContextLocations() {
        String[] base = super.getSpringContextLocations();
        String[] extended = new String[base.length + 1];
        System.arraycopy(base, 0, extended, 0, base.length);
        extended[base.length] = "classpath:/org/geoserver/wcs/ResourceAccessManagerContext.xml";
        return extended;
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        File security = new File(dataDirectory.getDataDirectoryRoot(), "security");
        security.mkdir();
        File users = new File(security, "users.properties");
        Properties props = new Properties();
        props.put("admin", "geoserver,ROLE_ADMINISTRATOR");
        props.put("cite", "cite,ROLE_DUMMY");
        props.put("cite_noworld", "cite,ROLE_DUMMY");
        props.put("cite_noworld_challenge", "cite,ROLE_DUMMY");
        props.put("cite_usa", "cite,ROLE_DUMMY");
        props.store(new FileOutputStream(users), "");
    }

    @Override
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        Catalog catalog = this.getCatalog();
        CoverageInfo world = catalog.getCoverageByName(this.getLayerId(MockData.WORLD));
        tam.putLimits("cite_noworld", (CatalogInfo)world, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, null));
        tam.putLimits("cite_noworld_challenge", (CatalogInfo)world, (AccessLimits)new CoverageAccessLimits(CatalogMode.CHALLENGE, (Filter)Filter.EXCLUDE, null, null));
        MultiPolygon rasterFilter = (MultiPolygon)new WKTReader().read("MULTIPOLYGON(((-120 30, -120 60, -60 60, -60 30, -120 30)))");
        tam.putLimits("cite_usa", (CatalogInfo)world, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, null, rasterFilter, null));
    }

    Map<String, Object> getWorld() {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.WORLD);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("store", "false");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        return raw;
    }

    public void testNoLimits() throws Exception {
        Map<String, Object> raw = this.getWorld();
        this.authenticate("cite", "cite");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        ResourceAccessManagerWCSTest.assertEquals((int)1, (int)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoordinateReferenceSystem wgs84Flipped = CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326");
        ResourceAccessManagerWCSTest.assertEquals((Object)wgs84Flipped, (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
        ResourceAccessManagerWCSTest.assertEquals((Object)-90.0, (Object)coverage.getEnvelope().getMinimum(0));
        ResourceAccessManagerWCSTest.assertEquals((Object)-180.0, (Object)coverage.getEnvelope().getMinimum(1));
        ResourceAccessManagerWCSTest.assertEquals((Object)90.0, (Object)coverage.getEnvelope().getMaximum(0));
        ResourceAccessManagerWCSTest.assertEquals((Object)180.0, (Object)coverage.getEnvelope().getMaximum(1));
        int[] value = new int[3];
        coverage.evaluate((DirectPosition)new DirectPosition2D(wgs84Flipped, 40.0, -90.0), value);
        ResourceAccessManagerWCSTest.assertTrue((value[0] > 0 ? 1 : 0) != 0);
        ResourceAccessManagerWCSTest.assertTrue((value[1] > 0 ? 1 : 0) != 0);
        ResourceAccessManagerWCSTest.assertTrue((value[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((DirectPosition)new DirectPosition2D(wgs84Flipped, 45.0, 12.0), value);
        ResourceAccessManagerWCSTest.assertTrue((value[0] > 0 ? 1 : 0) != 0);
        ResourceAccessManagerWCSTest.assertTrue((value[1] > 0 ? 1 : 0) != 0);
        ResourceAccessManagerWCSTest.assertTrue((value[2] > 0 ? 1 : 0) != 0);
    }

    public void testNoAccess() throws Exception {
        Map<String, Object> raw = this.getWorld();
        this.authenticate("cite_noworld", "cite");
        try {
            this.executeGetCoverageKvp(raw);
            ResourceAccessManagerWCSTest.fail((String)"This should have failed with an exception");
        }
        catch (WcsException e) {
            ResourceAccessManagerWCSTest.assertTrue((boolean)e.getMessage().matches(".*wcs:World.*"));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void testChallenge() throws Exception {
        block4: {
            raw = this.getWorld();
            this.authenticate("cite_noworld_challenge", "cite");
            try {
                this.executeGetCoverageKvp(raw);
                ResourceAccessManagerWCSTest.fail((String)"This should have failed with a security exception");
                break block4;
            }
            catch (Throwable e) {
                se = null;
                ** while (e.getCause() != null && e.getCause() != e)
            }
lbl-1000:
            // 1 sources

            {
                if (!((e = e.getCause()) instanceof SpringSecurityException)) continue;
                se = (SpringSecurityException)e;
                continue;
            }
lbl14:
            // 1 sources

            if (e == null) {
                // empty if block
            }
            ResourceAccessManagerWCSTest.assertTrue((boolean)se.getMessage().contains("World"));
            ResourceAccessManagerWCSTest.assertTrue((boolean)se.getMessage().contains("privileges"));
        }
    }

    public void testRasterFilterUSA() throws Exception {
        Map<String, Object> raw = this.getWorld();
        this.authenticate("cite_usa", "cite");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        ResourceAccessManagerWCSTest.assertEquals((int)1, (int)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoordinateReferenceSystem wgs84Flipped = CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326");
        ResourceAccessManagerWCSTest.assertEquals((Object)wgs84Flipped, (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
        ResourceAccessManagerWCSTest.assertEquals((Object)-90.0, (Object)coverage.getEnvelope().getMinimum(0));
        ResourceAccessManagerWCSTest.assertEquals((Object)-180.0, (Object)coverage.getEnvelope().getMinimum(1));
        ResourceAccessManagerWCSTest.assertEquals((Object)90.0, (Object)coverage.getEnvelope().getMaximum(0));
        ResourceAccessManagerWCSTest.assertEquals((Object)180.0, (Object)coverage.getEnvelope().getMaximum(1));
        int[] value = new int[3];
        coverage.evaluate((DirectPosition)new DirectPosition2D(wgs84Flipped, 40.0, -90.0), value);
        ResourceAccessManagerWCSTest.assertTrue((value[0] > 0 ? 1 : 0) != 0);
        ResourceAccessManagerWCSTest.assertTrue((value[1] > 0 ? 1 : 0) != 0);
        ResourceAccessManagerWCSTest.assertTrue((value[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((DirectPosition)new DirectPosition2D(wgs84Flipped, 45.0, 12.0), value);
        ResourceAccessManagerWCSTest.assertEquals((int)0, (int)value[0]);
        ResourceAccessManagerWCSTest.assertEquals((int)0, (int)value[1]);
        ResourceAccessManagerWCSTest.assertEquals((int)0, (int)value[2]);
    }

    protected void authenticate(String username, String password) {
        GrantedAuthorityImpl ga = new GrantedAuthorityImpl("MOCKROLE");
        UsernamePasswordAuthenticationToken user = new UsernamePasswordAuthenticationToken((Object)username, null, new GrantedAuthority[]{ga});
        SecurityContextHolder.getContext().setAuthentication((Authentication)user);
    }
}

