/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.GetCoverageType;
import net.opengis.wcs11.RangeSubsetType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wcs.kvp.GetCoverageRequestReader;
import org.geoserver.wcs.kvp.GridCS;
import org.geoserver.wcs.kvp.GridType;
import org.geoserver.wcs.test.WCSTestSupport;
import org.vfny.geoserver.wcs.WcsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCoverageReaderTest
extends WCSTestSupport {
    static GetCoverageRequestReader reader;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetCoverageReaderTest());
    }

    @Override
    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        Catalog catalog = (Catalog)applicationContext.getBean("catalog");
        reader = new GetCoverageRequestReader(catalog);
    }

    Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.1.1");
        raw.put("request", "GetCoverage");
        return raw;
    }

    public void testMissingParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"Hey, format is missing, this should have failed");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)"MissingParameterValue", (String)e.getCode());
        }
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"Hey, format is missing, this should have failed");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)"MissingParameterValue", (String)e.getCode());
        }
        raw.put("format", "image/tiff");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"Hey, boundingBox is missing, this should have failed");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)"MissingParameterValue", (String)e.getCode());
        }
        raw.put("BoundingBox", "-45,146,-42,147");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        }
        catch (WcsException e) {
            GetCoverageReaderTest.fail((String)"This time all mandatory params where provided?");
            GetCoverageReaderTest.assertEquals((String)"MissingParameterValue", (String)e.getCode());
        }
    }

    public void testUnknownCoverageParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = "fairyTales:rumpelstilskin";
        raw.put("identifier", "fairyTales:rumpelstilskin");
        raw.put("format", "SuperCoolFormat");
        raw.put("BoundingBox", "-45,146,-42,147");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"That coverage is not registered???");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"identifier", (String)e.getLocator());
        }
    }

    public void testBasic() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("store", "false");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        GetCoverageReaderTest.assertEquals((String)layerId, (String)getCoverage.getIdentifier().getValue());
        GetCoverageReaderTest.assertEquals((String)"image/tiff", (String)getCoverage.getOutput().getFormat());
        GetCoverageReaderTest.assertFalse((boolean)getCoverage.getOutput().isStore());
        GetCoverageReaderTest.assertEquals((String)"urn:ogc:def:crs:EPSG:6.6:4326", (String)getCoverage.getOutput().getGridCRS().getGridBaseCRS());
    }

    public void testUnsupportedCRS() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:-1000");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)"GridBaseCRS", (String)e.getLocator());
            GetCoverageReaderTest.assertEquals((String)"InvalidParameterValue", (String)e.getCode());
        }
    }

    public void testGridTypes() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("gridType", GridType.GT2dGridIn2dCrs.getXmlConstant());
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        GetCoverageReaderTest.assertEquals((String)GridType.GT2dGridIn2dCrs.getXmlConstant(), (String)getCoverage.getOutput().getGridCRS().getGridType());
        raw.put("gridType", GridType.GT2dSimpleGrid.getXmlConstant());
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        GetCoverageReaderTest.assertEquals((String)GridType.GT2dSimpleGrid.getXmlConstant(), (String)getCoverage.getOutput().getGridCRS().getGridType());
        raw.put("gridType", GridType.GT2dSimpleGrid.getXmlConstant().toUpperCase());
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        GetCoverageReaderTest.assertEquals((String)GridType.GT2dSimpleGrid.getXmlConstant(), (String)getCoverage.getOutput().getGridCRS().getGridType());
        raw.put("gridType", GridType.GT2dGridIn3dCrs.getXmlConstant());
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"GridType", (String)e.getLocator());
        }
        raw.put("gridType", "Hoolabaloola");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"GridType", (String)e.getLocator());
        }
    }

    public void testGridCS() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("GridCS", GridCS.GCSGrid2dSquare.getXmlConstant());
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        GetCoverageReaderTest.assertEquals((String)GridCS.GCSGrid2dSquare.getXmlConstant(), (String)getCoverage.getOutput().getGridCRS().getGridCS());
        raw.put("GridCS", GridCS.GCSGrid2dSquare.getXmlConstant().toUpperCase());
        getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        GetCoverageReaderTest.assertEquals((String)GridCS.GCSGrid2dSquare.getXmlConstant(), (String)getCoverage.getOutput().getGridCRS().getGridCS());
        raw.put("GridCS", "Hoolabaloola");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"GridCS", (String)e.getLocator());
        }
    }

    public void testGridOrigin() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("GridOrigin", "10.5,-30.2");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Double[] origin = (Double[])getCoverage.getOutput().getGridCRS().getGridOrigin();
        GetCoverageReaderTest.assertEquals((int)2, (int)origin.length);
        GetCoverageReaderTest.assertEquals((Object)10.5, (Object)origin[0]);
        GetCoverageReaderTest.assertEquals((Object)-30.2, (Object)origin[1]);
        raw.put("GridOrigin", "12");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"GridOrigin", (String)e.getLocator());
        }
        raw.put("GridOrigin", "12,a");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"GridOrigin", (String)e.getLocator());
        }
    }

    public void testGridOffsets() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("GridOffsets", "10.5,-30.2");
        raw.put("GridType", GridType.GT2dSimpleGrid.getXmlConstant());
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        Double[] offsets = (Double[])getCoverage.getOutput().getGridCRS().getGridOffsets();
        GetCoverageReaderTest.assertEquals((int)2, (int)offsets.length);
        GetCoverageReaderTest.assertEquals((Object)10.5, (Object)offsets[0]);
        GetCoverageReaderTest.assertEquals((Object)-30.2, (Object)offsets[1]);
        raw.put("GridOffsets", "12");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"GridOffsets", (String)e.getLocator());
        }
        raw.put("GridOffsets", "12,a");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"GridOffsets", (String)e.getLocator());
        }
    }

    public void testRangeSubset() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", layerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-45,146,-42,147");
        raw.put("rangeSubset", "BlueMarble:nearest[Bands[Red_band]]");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        RangeSubsetType rs = getCoverage.getRangeSubset();
        GetCoverageReaderTest.assertNotNull((Object)rs);
        GetCoverageReaderTest.assertEquals((int)1, (int)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        GetCoverageReaderTest.assertEquals((String)"BlueMarble", (String)field.getIdentifier().getValue());
        GetCoverageReaderTest.assertEquals((int)1, (int)field.getAxisSubset().size());
        AxisSubsetType axis = (AxisSubsetType)field.getAxisSubset().get(0);
        GetCoverageReaderTest.assertEquals((String)"Bands", (String)axis.getIdentifier());
        EList keys = axis.getKey();
        GetCoverageReaderTest.assertEquals((int)1, (int)keys.size());
        GetCoverageReaderTest.assertEquals((Object)"Red_band", keys.get(0));
    }
}

