/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.util.ArrayList;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wcs.test.WCSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescribeCoverageTest
extends WCSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new DescribeCoverageTest());
    }

    public void testDescribeNoIdentifiers() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1");
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("ows:ExceptionReport").getLength());
        Element element = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        DescribeCoverageTest.assertEquals((String)"MissingParameterValue", (String)element.getAttribute("exceptionCode"));
        DescribeCoverageTest.assertEquals((String)"identifiers", (String)element.getAttribute("locator"));
    }

    public void testDescribeUnknownCoverageKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=plop");
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        DescribeCoverageTest.assertEquals((String)"InvalidParameterValue", (String)element.getAttribute("exceptionCode"));
        DescribeCoverageTest.assertEquals((String)"identifiers", (String)element.getAttribute("locator"));
        DescribeCoverageTest.assertTrue((boolean)element.getTextContent().contains("plop"));
    }

    public void testDescribeMissingVersion() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&identifiers=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        DescribeCoverageTest.assertEquals((String)"MissingParameterValue", (String)element.getAttribute("exceptionCode"));
        DescribeCoverageTest.assertEquals((String)"version", (String)element.getAttribute("locator"));
    }

    public void testDescribeUnknownCoverageXml() throws Exception {
        ArrayList errors = new ArrayList();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.1.1\" >\r\n  <wcs:Identifier>plop</wcs:Identifier>\r\n</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs", request, errors);
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        DescribeCoverageTest.assertEquals((String)"InvalidParameterValue", (String)element.getAttribute("exceptionCode"));
        DescribeCoverageTest.assertEquals((String)"identifiers", (String)element.getAttribute("locator"));
        DescribeCoverageTest.assertTrue((boolean)element.getTextContent().contains("plop"));
    }

    public void testDescribeDemCoverageKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkDemCoverageDescription(dom);
    }

    public void testDescribeDemCoverageXml() throws Exception {
        ArrayList errors = new ArrayList();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.1.1\" >\r\n  <wcs:Identifier>" + this.getLayerId(MockData.TASMANIA_DEM) + "</wcs:Identifier>\r\n" + "</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs", request, errors);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkDemCoverageDescription(dom);
    }

    private void checkDemCoverageDescription(Document dom) throws Exception {
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescriptions").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.TASMANIA_DEM), (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Identifier", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Domain/wcs:SpatialDomain/wcs:GridCRS/wcs:GridOffsets", dom).item(0);
        String[] offsetStrs = gridOffsets.getTextContent().split(" ");
        DescribeCoverageTest.assertEquals((int)4, (int)offsetStrs.length);
        double[] offsets = new double[4];
        int i = 0;
        while (i < offsetStrs.length) {
            offsets[i] = Double.parseDouble(offsetStrs[i]);
            ++i;
        }
        DescribeCoverageTest.assertTrue((offsets[0] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((Object)0.0, (Object)offsets[1]);
        DescribeCoverageTest.assertEquals((Object)0.0, (Object)offsets[2]);
        DescribeCoverageTest.assertTrue((offsets[3] < 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:Field").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:Axis").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:Key").getLength());
    }

    public void testDescribeRotatedCoverage() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + this.getLayerId(MockData.ROTATED_CAD));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescriptions").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.ROTATED_CAD), (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Identifier", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Domain/wcs:SpatialDomain/wcs:GridCRS/wcs:GridOffsets", dom).item(0);
        String[] offsetStrs = gridOffsets.getTextContent().split(" ");
        DescribeCoverageTest.assertEquals((int)4, (int)offsetStrs.length);
        double[] offsets = new double[4];
        int i = 0;
        while (i < offsetStrs.length) {
            offsets[i] = Double.parseDouble(offsetStrs[i]);
            ++i;
        }
        DescribeCoverageTest.assertTrue((offsets[0] < 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertTrue((offsets[1] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertTrue((offsets[2] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertTrue((offsets[3] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:Field").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:Axis").getLength());
        DescribeCoverageTest.assertEquals((int)4, (int)dom.getElementsByTagName("wcs:Key").getLength());
    }

    public void testDescribeImageCoverage() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + this.getLayerId(MockData.TASMANIA_BM));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescriptions").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.TASMANIA_BM), (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Identifier", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Domain/wcs:SpatialDomain/wcs:GridCRS/wcs:GridOffsets", dom).item(0);
        String[] offsetStrs = gridOffsets.getTextContent().split(" ");
        DescribeCoverageTest.assertEquals((int)4, (int)offsetStrs.length);
        double[] offsets = new double[4];
        int i = 0;
        while (i < offsetStrs.length) {
            offsets[i] = Double.parseDouble(offsetStrs[i]);
            ++i;
        }
        DescribeCoverageTest.assertTrue((offsets[0] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((Object)0.0, (Object)offsets[1]);
        DescribeCoverageTest.assertEquals((Object)0.0, (Object)offsets[2]);
        DescribeCoverageTest.assertTrue((offsets[3] < 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:Field").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:Axis").getLength());
        DescribeCoverageTest.assertEquals((int)3, (int)dom.getElementsByTagName("wcs:Key").getLength());
        NodeList keys = dom.getElementsByTagName("wcs:Key");
        int i2 = 0;
        while (i2 < keys.getLength()) {
            Node key = keys.item(i2);
            DescribeCoverageTest.assertFalse((boolean)key.getTextContent().contains(" "));
            ++i2;
        }
        XMLAssert.assertXpathEvaluatesTo((String)"contents", (String)"/wcs:CoverageDescriptions/wcs:CoverageDescription/wcs:Range/wcs:Field/wcs:Identifier", (Document)dom);
    }

    public void testWorkspaceQualified() throws Exception {
        Document dom = this.getAsDOM("cdf/wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + MockData.TASMANIA_DEM.getLocalPart());
        DescribeCoverageTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.1.1&identifiers=" + MockData.TASMANIA_DEM.getLocalPart());
        DescribeCoverageTest.assertEquals((String)"wcs:CoverageDescriptions", (String)dom.getDocumentElement().getNodeName());
    }
}

