/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.BufferedReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Test;
import org.geoserver.filters.BufferedRequestWrapper;
import org.geoserver.filters.RequestWrapperTestSupport;
import org.geoserver.test.OneTimeSetupTest;

public class BufferedRequestWrapperTest
extends RequestWrapperTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new BufferedRequestWrapperTest());
    }

    public void testGetInputStream() throws Exception {
        for (int i = 0; i < this.testStrings.length; ++i) {
            this.doInputStreamTest(this.testStrings[i]);
        }
    }

    public void testGetReader() throws Exception {
        for (int i = 0; i < this.testStrings.length; ++i) {
            this.doGetReaderTest(this.testStrings[i]);
        }
    }

    public void doInputStreamTest(String testString) throws Exception {
        int amountRead;
        HttpServletRequest req = this.makeRequest(testString);
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper(req, testString);
        ServletInputStream sis = req.getInputStream();
        byte[] b = new byte[32];
        while (sis.readLine(b, 0, 32) > 0) {
        }
        sis = wrapper.getInputStream();
        StringBuffer buff = new StringBuffer();
        while ((amountRead = sis.readLine(b, 0, 32)) != 0) {
            buff.append(new String(b, 0, amountRead));
        }
        BufferedRequestWrapperTest.assertEquals((String)buff.toString(), (String)testString);
    }

    public void doGetReaderTest(String testString) throws Exception {
        int c;
        HttpServletRequest req = this.makeRequest(testString);
        BufferedReader br = req.getReader();
        while (br.readLine() != null) {
        }
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper(req, testString);
        StringBuffer buff = new StringBuffer();
        br = wrapper.getReader();
        while ((c = br.read()) != -1) {
            buff.append((char)c);
        }
        BufferedRequestWrapperTest.assertEquals((String)buff.toString(), (String)testString);
    }
}

