/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ResourceReference;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.requests.GetMapRequest;

public class PreviewLayer {
    static final Logger LOGGER = Logging.getLogger(PreviewLayer.class);
    LayerInfo layerInfo;
    LayerGroupInfo groupInfo;
    transient GetMapRequest request;

    public PreviewLayer(LayerInfo layerInfo) {
        this.layerInfo = layerInfo;
    }

    public PreviewLayer(LayerGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public String getName() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getPrefixedName();
        }
        return this.groupInfo.getName();
    }

    public ResourceReference getIcon() {
        if (this.layerInfo != null) {
            return CatalogIconFactory.get().getLayerIcon(this.layerInfo);
        }
        return CatalogIconFactory.GROUP_ICON;
    }

    public ResourceReference getTypeSpecificIcon() {
        if (this.layerInfo != null) {
            return CatalogIconFactory.get().getSpecificLayerIcon(this.layerInfo);
        }
        return CatalogIconFactory.GROUP_ICON;
    }

    public String getTitle() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getTitle();
        }
        return "";
    }

    public String getAbstract() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getAbstract();
        }
        return "";
    }

    public String getKeywords() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getKeywords().toString();
        }
        return "";
    }

    public PreviewLayerType getType() {
        if (this.layerInfo != null) {
            if (this.layerInfo.getType() == LayerInfo.Type.RASTER) {
                return PreviewLayerType.Raster;
            }
            if (this.layerInfo.getType() == LayerInfo.Type.VECTOR) {
                return PreviewLayerType.Vector;
            }
            return PreviewLayerType.Remote;
        }
        return PreviewLayerType.Group;
    }

    GetMapRequest getRequest() {
        if (this.request == null) {
            GeoServerApplication app = GeoServerApplication.get();
            this.request = new GetMapRequest(new WMS(app.getGeoServer()));
            Catalog catalog = app.getCatalog();
            List<MapLayerInfo> layers = this.expandLayers(catalog);
            this.request.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
            this.request.setFormat("application/openlayers");
            if (this.groupInfo != null) {
                ReferencedEnvelope bounds = this.groupInfo.getBounds();
                this.request.setBbox((Envelope)bounds);
                String epsgCode = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem());
                if (epsgCode != null) {
                    this.request.setSRS("EPSG:" + epsgCode);
                }
            }
            try {
                DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)this.request);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Could not set figure out automatically a good preview link for " + this.getName(), e);
            }
        }
        return this.request;
    }

    private List<MapLayerInfo> expandLayers(Catalog catalog) {
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        if (this.layerInfo != null) {
            layers.add(new MapLayerInfo(this.layerInfo));
        } else {
            for (LayerInfo l : this.groupInfo.getLayers()) {
                layers.add(new MapLayerInfo(l));
            }
        }
        return layers;
    }

    public String getWmsLink() {
        GetMapRequest request = this.getRequest();
        Envelope bbox = request.getBbox();
        if (bbox == null) {
            return null;
        }
        return "../wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getName() + "&styles=" + "&bbox=" + bbox.getMinX() + "," + bbox.getMinY() + "," + bbox.getMaxX() + "," + bbox.getMaxY() + "&width=" + request.getWidth() + "&height=" + request.getHeight() + "&srs=" + request.getSRS();
    }

    public static enum PreviewLayerType {
        Raster,
        Vector,
        Remote,
        Group;

    }
}

