/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.IOException;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.security.DataAccessRule;
import org.geoserver.security.DataAccessRuleDAO;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.security.ConfirmRemovalDataAccessRulePanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionDataRuleRemovalLink
extends AjaxLink {
    GeoServerTablePanel<DataAccessRule> rules;
    GeoServerDialog dialog;

    public SelectionDataRuleRemovalLink(String id, GeoServerTablePanel<DataAccessRule> rules, GeoServerDialog dialog) {
        super(id);
        this.rules = rules;
        this.dialog = dialog;
    }

    public void onClick(AjaxRequestTarget target) {
        final List selection = this.rules.getSelection();
        if (selection.size() == 0) {
            return;
        }
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

            protected Component getContents(String id) {
                return new ConfirmRemovalDataAccessRulePanel(id, selection){

                    protected StringResourceModel canRemove(DataAccessRule data) {
                        return SelectionDataRuleRemovalLink.this.canRemove(data);
                    }
                };
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                Catalog catalog = GeoServerApplication.get().getCatalog();
                CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
                DataAccessRuleDAO dao = DataAccessRuleDAO.get();
                for (DataAccessRule rule : selection) {
                    dao.removeRule((Comparable)rule);
                }
                try {
                    dao.storeRules();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SelectionDataRuleRemovalLink.this.rules.clearSelection();
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (SelectionDataRuleRemovalLink.this.rules.getSelection().size() == 0) {
                    SelectionDataRuleRemovalLink.this.setEnabled(false);
                    target.addComponent((Component)SelectionDataRuleRemovalLink.this);
                    target.addComponent(SelectionDataRuleRemovalLink.this.rules);
                }
            }
        });
    }

    protected StringResourceModel canRemove(DataAccessRule data) {
        return null;
    }
}

