/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.user;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.GeoserverUserDao;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListProvider
extends GeoServerDataProvider<User> {
    public static final GeoServerDataProvider.Property<User> USERNAME = new GeoServerDataProvider.BeanProperty("username", "username");
    public static final GeoServerDataProvider.Property<User> ROLES = new GeoServerDataProvider.Property<User>(){

        public Comparator<User> getComparator() {
            return new GeoServerDataProvider.PropertyComparator((GeoServerDataProvider.Property)this);
        }

        public IModel getModel(IModel itemModel) {
            return new Model((Serializable)((Object)((String)this.getPropertyValue((User)itemModel.getObject()))));
        }

        public String getName() {
            return "roles";
        }

        public Object getPropertyValue(User item) {
            if (item.getAuthorities().length == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            GrantedAuthority[] grantedAuthorityArray = item.getAuthorities();
            int n = grantedAuthorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                GrantedAuthority ga = grantedAuthorityArray[n2];
                sb.append(ga.getAuthority());
                sb.append(",");
                ++n2;
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        public boolean isVisible() {
            return true;
        }
    };
    public static final GeoServerDataProvider.Property<User> ADMIN = new GeoServerDataProvider.Property<User>(){

        public Comparator<User> getComparator() {
            return new GeoServerDataProvider.PropertyComparator((GeoServerDataProvider.Property)this);
        }

        public IModel getModel(IModel itemModel) {
            return new Model((Serializable)((Boolean)this.getPropertyValue((User)itemModel.getObject())));
        }

        public String getName() {
            return "admin";
        }

        public Object getPropertyValue(User item) {
            GrantedAuthority[] grantedAuthorityArray = item.getAuthorities();
            int n = grantedAuthorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                GrantedAuthority ga = grantedAuthorityArray[n2];
                if (ga.getAuthority().equals("ROLE_ADMINISTRATOR")) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean isVisible() {
            return true;
        }
    };

    protected List<User> getItems() {
        GeoserverUserDao users = (GeoserverUserDao)GeoServerApplication.get().getBean("userDetailsService");
        return users.getUsers();
    }

    protected List<GeoServerDataProvider.Property<User>> getProperties() {
        return Arrays.asList(USERNAME, ROLES, ADMIN);
    }

    public IModel model(Object object) {
        return new Model((Serializable)((User)object));
    }
}

