/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.data;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.MockData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.security.data.DataAccessRulePage;
import org.geoserver.web.security.data.NewDataAccessRulePage;

public class NewRulePageTest
extends GeoServerWicketTestSupport {
    private DataAccessRuleDAO dao;
    private NewDataAccessRulePage page;

    protected void setUpInternal() throws Exception {
        this.dao = DataAccessRuleDAO.get();
        this.login();
        this.page = new NewDataAccessRulePage();
        tester.startPage((Page)this.page);
    }

    public void testRenders() {
        tester.assertRenderedPage(NewDataAccessRulePage.class);
    }

    public void testFill() {
        Locale.setDefault(Locale.ENGLISH);
        tester.assertComponent("ruleForm:roles:roles:recorder", Recorder.class);
        FormTester form = tester.newFormTester("ruleForm");
        form.select("workspace", this.page.getWorkspaceNames().indexOf(MockData.CITE_PREFIX));
        form.select("accessMode", 1);
        form.setValue("roles:roles:recorder", "*");
        tester.assertRenderedPage(NewDataAccessRulePage.class);
        form.submit("save");
        tester.assertErrorMessages(new String[0]);
        tester.assertRenderedPage(DataAccessRulePage.class);
        this.dao.reload();
        NewRulePageTest.assertEquals((int)1, (int)this.dao.getRules().size());
        DataAccessRule rule = (DataAccessRule)this.dao.getRules().get(0);
        NewRulePageTest.assertEquals((String)"cite", (String)rule.getWorkspace());
        NewRulePageTest.assertEquals((String)"*", (String)rule.getLayer());
        NewRulePageTest.assertEquals((Object)AccessMode.WRITE, (Object)rule.getAccessMode());
    }

    public void testAjaxUpdate() {
        FormTester form = tester.newFormTester("ruleForm");
        form.select("workspace", this.page.getWorkspaceNames().indexOf(MockData.CITE_PREFIX));
        ArrayList layers = this.page.getLayerNames(MockData.CITE_PREFIX);
        tester.executeAjaxEvent("ruleForm:workspace", "onchange");
        NewRulePageTest.assertEquals((Object)layers, (Object)((DropDownChoice)tester.getComponentFromLastRenderedPage("ruleForm:layer")).getChoices());
    }
}

