/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.StringResourceModel;
import org.springframework.security.userdetails.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmRemovalUserPanel
extends Panel {
    List<User> roots;

    public ConfirmRemovalUserPanel(String id, User ... roots) {
        this(id, Arrays.asList(roots));
    }

    public ConfirmRemovalUserPanel(String id, List<User> roots) {
        super(id);
        this.roots = roots;
        WebMarkupContainer root = new WebMarkupContainer("rootObjects");
        root.add(new Component[]{new Label("rootObjectNames", this.names(roots))});
        root.setVisible(!roots.isEmpty());
        this.add(new Component[]{root});
        WebMarkupContainer removed = new WebMarkupContainer("removedObjects");
        this.add(new Component[]{removed});
        WebMarkupContainer rulesRemoved = new WebMarkupContainer("rulesRemoved");
        removed.add(new Component[]{rulesRemoved});
        List<User> rules = roots;
        if (rules.size() == 0) {
            rulesRemoved.setVisible(false);
        }
        rulesRemoved.add(new Component[]{new Label("rules", this.names(rules))});
    }

    String names(List objects) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < objects.size()) {
            sb.append(this.name(objects.get(i)));
            if (i < objects.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    String name(Object object) {
        try {
            return BeanUtils.getProperty((Object)object, (String)"username");
        }
        catch (Exception e) {
            throw new RuntimeException("A data object that does not have a 'name' property has been used, this is unexpected", e);
        }
    }

    protected StringResourceModel canRemove(User data) {
        return null;
    }
}

