/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.user;

import java.util.Locale;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.impl.GeoserverUserDao;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.security.user.NewUserPage;
import org.geoserver.web.security.user.UserPage;
import org.springframework.security.userdetails.UserDetails;

public class NewUserPageTest
extends GeoServerWicketTestSupport {
    private GeoserverUserDao dao;

    protected void setUpInternal() throws Exception {
        this.dao = GeoserverUserDao.get();
        this.login();
        tester.startPage((Page)new NewUserPage());
    }

    public void testRenders() {
        tester.assertRenderedPage(NewUserPage.class);
    }

    public void testFill() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        tester.assertComponent("userForm:roles:roles:recorder", Recorder.class);
        FormTester form = tester.newFormTester("userForm");
        form.setValue("username", "user");
        form.setValue("password", "pwd");
        form.setValue("confirmPassword", "pwd");
        form.setValue("roles:roles:recorder", (String)this.dao.getRoles().get(0));
        form.submit("save");
        tester.assertErrorMessages(new String[0]);
        tester.assertRenderedPage(UserPage.class);
        this.dao.reload();
        UserDetails user = this.dao.loadUserByUsername("user");
        NewUserPageTest.assertEquals((String)"pwd", (String)user.getPassword());
        NewUserPageTest.assertEquals((int)1, (int)user.getAuthorities().length);
    }

    public void testPasswordsDontMatch() {
        Locale.setDefault(Locale.ENGLISH);
        FormTester form = tester.newFormTester("userForm");
        form.setValue("username", "user");
        form.setValue("password", "pwd1");
        form.setValue("confirmPassword", "pwd2");
        form.setValue("roles:roles:recorder", (String)this.dao.getRoles().get(0));
        form.submit("save");
        tester.assertErrorMessages(new String[]{"'pwd1' from Password and 'pwd2' from Confirm password must be equal."});
        tester.assertRenderedPage(NewUserPage.class);
    }
}

