/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.IOException;
import java.util.List;
import org.acegisecurity.userdetails.User;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoserverUserDao;
import org.geoserver.web.security.ConfirmRemovalUserPanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionUserRemovalLink
extends AjaxLink {
    GeoServerTablePanel<User> users;
    GeoServerDialog dialog;

    public SelectionUserRemovalLink(String id, GeoServerTablePanel<User> users, GeoServerDialog dialog) {
        super(id);
        this.users = users;
        this.dialog = dialog;
    }

    public void onClick(AjaxRequestTarget target) {
        final List selection = this.users.getSelection();
        if (selection.size() == 0) {
            return;
        }
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

            protected Component getContents(String id) {
                return new ConfirmRemovalUserPanel(id, selection){

                    protected StringResourceModel canRemove(User user) {
                        return SelectionUserRemovalLink.this.canRemove(user);
                    }
                };
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                GeoserverUserDao dao = GeoserverUserDao.get();
                for (User user : selection) {
                    if (user.getUsername().equals("admin")) continue;
                    dao.removeUser(user.getUsername());
                }
                try {
                    dao.storeUsers();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SelectionUserRemovalLink.this.users.clearSelection();
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (SelectionUserRemovalLink.this.users.getSelection().size() == 0) {
                    SelectionUserRemovalLink.this.setEnabled(false);
                    target.addComponent((Component)SelectionUserRemovalLink.this);
                    target.addComponent(SelectionUserRemovalLink.this.users);
                }
            }
        });
    }

    protected StringResourceModel canRemove(User user) {
        return null;
    }
}

