/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFSAdminPage
extends BaseServiceAdminPage<WFSInfo> {
    protected Class<WFSInfo> getServiceClass() {
        return WFSInfo.class;
    }

    protected void build(final IModel info, Form form) {
        form.add((Component)new TextField("maxFeatures"));
        form.add((Component)new CheckBox("featureBounding"));
        RadioGroup sl = new RadioGroup("serviceLevel");
        form.add((Component)sl);
        sl.add((Component)new Radio("basic", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.BASIC)));
        sl.add((Component)new Radio("transactional", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.TRANSACTIONAL)));
        sl.add((Component)new Radio("complete", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.COMPLETE)));
        LoadableDetachableModel gml2Model = new LoadableDetachableModel(){

            public Object load() {
                return ((WFSInfo)info.getObject()).getGML().get(WFSInfo.Version.V_10);
            }
        };
        LoadableDetachableModel gml3Model = new LoadableDetachableModel(){

            public Object load() {
                return ((WFSInfo)info.getObject()).getGML().get(WFSInfo.Version.V_11);
            }
        };
        form.add((Component)new GMLPanel("gml2", (IModel)gml2Model));
        form.add((Component)new GMLPanel("gml3", (IModel)gml3Model));
        form.add((Component)new CheckBox("canonicalSchemaLocation"));
    }

    protected String getServiceName() {
        return "WFS";
    }

    static class GMLPanel
    extends Panel {
        public GMLPanel(String id, IModel gmlModel) {
            super(id, (IModel)new CompoundPropertyModel((Object)gmlModel));
            List<GMLInfo.SrsNameStyle> choices = Arrays.asList(GMLInfo.SrsNameStyle.values());
            DropDownChoice srsNameStyle = new DropDownChoice("srsNameStyle", choices);
            this.add((Component)srsNameStyle);
        }
    }
}

