/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.NumberValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.publish.LayerConfigurationPanel;

public class AttributionLayerConfigPanel
extends LayerConfigurationPanel {
    public AttributionLayerConfigPanel(String id, IModel model) {
        super(id, model);
        LayerInfo layer = (LayerInfo)model.getObject();
        if (layer.getAttribution() == null) {
            layer.setAttribution(GeoServerApplication.get().getCatalog().getFactory().createAttribution());
        }
        AttributionInfo attr = layer.getAttribution();
        this.add((Component)new TextField("wms.attribution.title", (IModel)new PropertyModel((Object)model, "attribution.title")));
        TextField href = new TextField("wms.attribution.href", (IModel)new PropertyModel((Object)model, "attribution.href"));
        href.add((IValidator)new UrlValidator());
        href.setOutputMarkupId(true);
        this.add((Component)href);
        final TextField logo = new TextField("wms.attribution.logo", (IModel)new PropertyModel((Object)model, "attribution.logoURL"));
        logo.add((IValidator)new UrlValidator());
        logo.setOutputMarkupId(true);
        this.add((Component)logo);
        final TextField type = new TextField("wms.attribution.type", (IModel)new PropertyModel((Object)model, "attribution.logoType"));
        type.setOutputMarkupId(true);
        this.add((Component)type);
        final TextField height = new TextField("wms.attribution.height", (IModel)new PropertyModel((Object)model, "attribution.logoHeight"), Integer.class);
        height.add((IValidator)NumberValidator.minimum((long)0L));
        height.setOutputMarkupId(true);
        this.add((Component)height);
        final TextField width = new TextField("wms.attribution.width", (IModel)new PropertyModel((Object)model, "attribution.logoWidth"), Integer.class);
        width.add((IValidator)NumberValidator.minimum((long)0L));
        width.setOutputMarkupId(true);
        this.add((Component)width);
        this.add((Component)new AjaxSubmitLink("verifyImage"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                if (logo.getModelObjectAsString() != null) {
                    try {
                        URL url = new URL(logo.getModelObjectAsString());
                        URLConnection conn = url.openConnection();
                        type.getModel().setObject((Object)conn.getContentType());
                        BufferedImage image = ImageIO.read(conn.getInputStream());
                        height.setModelValue("" + image.getHeight());
                        width.setModelValue("" + image.getWidth());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                target.addComponent((Component)type);
                target.addComponent((Component)height);
                target.addComponent((Component)width);
            }
        });
    }
}

