/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.lang.Bytes;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.wicket.EditAreaBehavior;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wms.web.data.StylePage;
import org.geoserver.wms.web.publish.StyleChoiceRenderer;
import org.geoserver.wms.web.publish.StylesModel;
import org.geotools.sld.SLDConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStylePage
extends GeoServerSecuredPage {
    protected TextField nameTextField;
    protected FileUploadField fileUploadField;
    protected DropDownChoice styles;
    protected AjaxSubmitLink copyLink;
    protected Form uploadForm;
    protected Form styleForm;
    private TextArea editor;
    String rawSLD;

    public AbstractStylePage() {
    }

    public AbstractStylePage(StyleInfo style) {
        this.initUI(style);
    }

    protected void initUI(StyleInfo style) {
        this.styleForm = new Form("form", (IModel)new CompoundPropertyModel(style != null ? new StyleDetachableModel(style) : this.getCatalog().getFactory().createStyle())){

            protected void onSubmit() {
                AbstractStylePage.this.onStyleFormSubmit();
            }
        };
        this.styleForm.setMarkupId("mainForm");
        this.add((Component)this.styleForm);
        this.nameTextField = new TextField("name");
        this.styleForm.add((Component)this.nameTextField);
        this.nameTextField.setRequired(true);
        this.editor = new TextArea("editor", (IModel)new PropertyModel((Object)this, "rawSLD"));
        this.styleForm.add((Component)this.editor);
        this.editor.setMarkupId("editor");
        this.editor.setOutputMarkupId(true);
        this.editor.add((IBehavior)new EditAreaBehavior());
        this.styleForm.add((Component)this.editor);
        if (style != null) {
            try {
                this.setRawSLD(this.readFile(style));
            }
            catch (IOException e) {
                Session.get().error(new ParamResourceModel("sldNotFound", (Component)this, new Object[]{style.getFilename()}).getString());
            }
        }
        this.styles = new DropDownChoice("existingStyles", (IModel)new Model(), (IModel)new StylesModel(), (IChoiceRenderer)new StyleChoiceRenderer());
        this.styles.setOutputMarkupId(true);
        this.styles.add((IBehavior)new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractStylePage.this.styles.validate();
                AbstractStylePage.this.copyLink.setEnabled(AbstractStylePage.this.styles.getConvertedInput() != null);
                target.addComponent((Component)AbstractStylePage.this.copyLink);
            }
        });
        this.styleForm.add((Component)this.styles);
        this.copyLink = this.copyLink();
        this.copyLink.setEnabled(false);
        this.styleForm.add((Component)this.copyLink);
        this.uploadForm = this.uploadForm(this.styleForm);
        this.uploadForm.setMultiPart(true);
        this.uploadForm.setMaxSize(Bytes.megabytes((long)1L));
        this.uploadForm.setMarkupId("uploadForm");
        this.add((Component)this.uploadForm);
        this.fileUploadField = new FileUploadField("filename");
        this.uploadForm.add((Component)this.fileUploadField);
        this.add(this.validateLink());
        Link cancelLink = new Link("cancel"){

            public void onClick() {
                this.setResponsePage(StylePage.class);
            }
        };
        this.add((Component)cancelLink);
    }

    Form uploadForm(final Form form) {
        return new Form("uploadForm"){

            protected void onSubmit() {
                FileUpload upload = AbstractStylePage.this.fileUploadField.getFileUpload();
                if (upload == null) {
                    this.warn("No file selected.");
                    return;
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)upload.getInputStream(), (OutputStream)bout);
                    AbstractStylePage.this.setRawSLD(new InputStreamReader(new ByteArrayInputStream(bout.toByteArray())));
                    AbstractStylePage.this.editor.setModelObject((Object)AbstractStylePage.this.rawSLD);
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                StyleInfo s = (StyleInfo)form.getModelObject();
                if (s.getName() == null || "".equals(s.getName().trim())) {
                    AbstractStylePage.this.nameTextField.setModelValue(ResponseUtils.stripExtension((String)upload.getClientFileName()));
                    AbstractStylePage.this.nameTextField.modelChanged();
                }
            }
        };
    }

    Component validateLink() {
        return new GeoServerAjaxFormLink("validate", this.styleForm){

            protected void onClick(AjaxRequestTarget target, Form form) {
                AbstractStylePage.this.editor.validate();
                List<Exception> errors = AbstractStylePage.this.validateSLD();
                if (errors.isEmpty()) {
                    form.info("No validation errors.");
                } else {
                    for (Exception e : errors) {
                        form.error((Serializable)e);
                    }
                }
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new AjaxCallDecorator(){

                    public CharSequence decorateScript(CharSequence script) {
                        return "document.getElementById('editor').value = editAreaLoader.getValue('editor');" + script;
                    }
                };
            }
        };
    }

    List<Exception> validateSLD() {
        Parser parser = new Parser((Configuration)new SLDConfiguration());
        try {
            parser.validate((InputStream)new ByteArrayInputStream(this.editor.getInput().getBytes()));
        }
        catch (Exception e) {
            return Arrays.asList(e);
        }
        return parser.getValidationErrors();
    }

    AjaxSubmitLink copyLink() {
        return new AjaxSubmitLink("copy"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                AbstractStylePage.this.styles.processInput();
                StyleInfo style = (StyleInfo)AbstractStylePage.this.styles.getConvertedInput();
                if (style != null) {
                    try {
                        AbstractStylePage.this.editor.validate();
                        AbstractStylePage.this.editor.clearInput();
                        AbstractStylePage.this.setRawSLD(AbstractStylePage.this.readFile(style));
                    }
                    catch (Exception e) {
                        this.error((Serializable)((Object)("Errors occurred loading the '" + style.getName() + "' style")));
                    }
                    target.addComponent((Component)AbstractStylePage.this.styleForm);
                }
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                    public CharSequence preDecorateScript(CharSequence script) {
                        return "if(editAreaLoader.getValue('" + AbstractStylePage.this.editor.getMarkupId() + "') != '' &&" + "!confirm('" + new ParamResourceModel("confirmOverwrite", (Component)AbstractStylePage.this, new Object[0]).getString() + "')) return false;" + script;
                    }
                };
            }

            public boolean getDefaultFormProcessing() {
                return false;
            }
        };
    }

    Reader readFile(StyleInfo style) throws IOException {
        ResourcePool pool = this.getCatalog().getResourcePool();
        return pool.readStyle(style);
    }

    public void setRawSLD(Reader in) throws IOException {
        BufferedReader bin = null;
        bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = bin.readLine()) != null) {
            builder.append(line).append("\n");
        }
        this.rawSLD = builder.toString();
        this.editor.setModelObject((Object)this.rawSLD);
        in.close();
    }

    protected abstract void onStyleFormSubmit();
}

