/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.SelectionRemovalLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geoserver.wms.web.data.StyleNewPage;
import org.geoserver.wms.web.data.StyleProvider;

public class StylePage
extends GeoServerSecuredPage {
    GeoServerTablePanel<StyleInfo> table;
    SelectionRemovalLink removal;
    GeoServerDialog dialog;

    public StylePage() {
        StyleProvider provider = new StyleProvider();
        this.table = new GeoServerTablePanel<StyleInfo>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<StyleInfo> property) {
                if (property == StyleProvider.NAME) {
                    return StylePage.this.styleLink(id, itemModel);
                }
                return null;
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                StylePage.this.removal.setEnabled(StylePage.this.table.getSelection().size() > 0);
                target.addComponent((Component)StylePage.this.removal);
            }
        };
        this.add((Component)this.table);
        this.table.setOutputMarkupId(true);
        this.dialog = new GeoServerDialog("dialog");
        this.add((Component)this.dialog);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add((Component)new BookmarkablePageLink("addNew", StyleNewPage.class));
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog){

            protected StringResourceModel canRemove(CatalogInfo object) {
                StyleInfo s = (StyleInfo)object;
                if ("point".equals(s.getName()) || "line".equals(s.getName()) || "polygon".equals(s.getName()) || "raster".equals(s.getName())) {
                    return new StringResourceModel("cantRemoveDefaultStyle", (Component)StylePage.this, null);
                }
                return null;
            }
        };
        header.add((Component)this.removal);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    Component styleLink(String id, IModel model) {
        IModel nameModel = StyleProvider.NAME.getModel(model);
        String name = (String)nameModel.getObject();
        return new SimpleBookmarkableLink(id, StyleEditPage.class, nameModel, new String[]{"name", name});
    }
}

