/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.apache.wicket.validation.validator.NumberValidator;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geotools.referencing.CRS;

public class WMSAdminPage
extends BaseServiceAdminPage<WMSInfo> {
    static final List<String> SVG_RENDERERS = Arrays.asList("Batik", "Simple");

    protected Class<WMSInfo> getServiceClass() {
        return WMSInfo.class;
    }

    protected void build(IModel info, Form form) {
        TextArea srsList = new TextArea("srs", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)info, "sRS"))){

            public IConverter getConverter(Class type) {
                return new SRSListConverter();
            }
        };
        srsList.add((IValidator)new SRSListValidator());
        srsList.setType(List.class);
        form.add((Component)srsList);
        form.add((Component)new DropDownChoice("interpolation", Arrays.asList(WMSInfo.WMSInterpolation.values()), (IChoiceRenderer)new InterpolationRenderer()));
        TextField maxMemory = new TextField("maxRequestMemory");
        maxMemory.add((IValidator)NumberValidator.minimum((double)0.0));
        form.add((Component)maxMemory);
        TextField maxTime = new TextField("maxRenderingTime");
        maxTime.add((IValidator)NumberValidator.minimum((double)0.0));
        form.add((Component)maxTime);
        TextField maxErrors = new TextField("maxRenderingErrors");
        maxErrors.add((IValidator)NumberValidator.minimum((double)0.0));
        form.add((Component)maxErrors);
        form.add((Component)new CheckBox("watermark.enabled"));
        form.add((Component)new TextField("watermark.uRL"));
        TextField transparency = new TextField("watermark.transparency");
        transparency.add((IValidator)NumberValidator.range((long)0L, (long)100L));
        form.add((Component)transparency);
        form.add((Component)new DropDownChoice("watermark.position", Arrays.asList(WatermarkInfo.Position.values()), (IChoiceRenderer)new WatermarkPositionRenderer()));
        PropertyModel metadataModel = new PropertyModel((Object)info, "metadata");
        form.add((Component)new CheckBox("svg.antialias", (IModel)new MapModel((IModel)metadataModel, "svgAntiAlias")));
        form.add((Component)new DropDownChoice("svg.producer", (IModel)new MapModel((IModel)metadataModel, "svgRenderer"), SVG_RENDERERS, (IChoiceRenderer)new SVGMethodRenderer()));
    }

    protected String getServiceName() {
        return "WMS";
    }

    private static class SRSListValidator
    extends AbstractValidator {
        private SRSListValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            List srsList = (List)validatable.getValue();
            ArrayList<String> invalid = new ArrayList<String>();
            for (String srs : srsList) {
                try {
                    CRS.decode((String)("EPSG:" + srs));
                }
                catch (Exception e) {
                    invalid.add(srs);
                }
            }
            if (invalid.size() > 0) {
                this.error(validatable, "WMSAdminPage.unknownEPSGCodes", Collections.singletonMap("codes", ((Object)invalid).toString()));
            }
        }
    }

    private static class SRSListConverter
    implements IConverter {
        static final Pattern COMMA_SEPARATED = Pattern.compile("\\s*,\\s*", 8);

        private SRSListConverter() {
        }

        public String convertToString(Object value, Locale locale) {
            List srsList = (List)value;
            if (srsList.isEmpty()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (String srs : srsList) {
                sb.append(srs).append(", ");
            }
            sb.setLength(sb.length() - 2);
            return sb.toString();
        }

        public Object convertToObject(String value, Locale locale) {
            if (value == null || value.trim().equals("")) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(Arrays.asList(COMMA_SEPARATED.split(value)));
        }
    }

    private class SVGMethodRenderer
    implements IChoiceRenderer {
        private SVGMethodRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel("svg." + object, (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return (String)object;
        }
    }

    private class InterpolationRenderer
    implements IChoiceRenderer {
        private InterpolationRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((WMSInfo.WMSInterpolation)object).name(), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((WMSInfo.WMSInterpolation)object).name();
        }
    }

    private class WatermarkPositionRenderer
    implements IChoiceRenderer {
        private WatermarkPositionRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((WatermarkInfo.Position)object).name(), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((WatermarkInfo.Position)object).name();
        }
    }
}

