/* Copyright (c) 2001 - 2007 TOPP - www.openplans.org. All rights reserved.
 * This code is licensed under the GPL 2.0 license, availible at the root
 * application directory.
 */
package org.geoserver.wfs.xml.v1_0_0;

import net.opengis.wfs.WfsFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import javax.xml.namespace.QName;


/**
 * Binding object for the type http://www.opengis.net/wfs:NativeType.
 *
 * <p>
 *        <pre>
 *         <code>
 *  &lt;xsd:complexType name="NativeType"&gt;
 *      &lt;xsd:attribute name="vendorId" type="xsd:string" use="required"&gt;
 *          &lt;xsd:annotation&gt;
 *              &lt;xsd:documentation&gt;
 *                 The vendorId attribute is used to specify the name of
 *                 vendor who's vendor specific command the client
 *                 application wishes to execute.
 *              &lt;/xsd:documentation&gt;
 *          &lt;/xsd:annotation&gt;
 *      &lt;/xsd:attribute&gt;
 *      &lt;xsd:attribute name="safeToIgnore" type="xsd:boolean" use="required"&gt;
 *          &lt;xsd:annotation&gt;
 *              &lt;xsd:documentation&gt;
 *                 In the event that a Web Feature Service does not recognize
 *                 the vendorId or does not recognize the vendor specific command,
 *                 the safeToIgnore attribute is used to indicate whether the
 *                 exception can be safely ignored.  A value of TRUE means that
 *                 the Web Feature Service may ignore the command.  A value of
 *                 FALSE means that a Web Feature Service cannot ignore the
 *                 command and an exception should be raised if a problem is
 *                 encountered.
 *              &lt;/xsd:documentation&gt;
 *          &lt;/xsd:annotation&gt;
 *      &lt;/xsd:attribute&gt;
 *  &lt;/xsd:complexType&gt;
 *
 *          </code>
 *         </pre>
 * </p>
 *
 * @generated
 */
public class NativeTypeBinding extends AbstractComplexBinding {
    WfsFactory wfsfactory;

    public NativeTypeBinding(WfsFactory wfsfactory) {
        this.wfsfactory = wfsfactory;
    }

    /**
     * @generated
     */
    public QName getTarget() {
        return WFS.NATIVETYPE;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    public Class getType() {
        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    public Object parse(ElementInstance instance, Node node, Object value)
        throws Exception {
        //TODO: implement
        return null;
    }
}
