/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.response.ShapeZipOutputFormat;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class ShapeZipTest
extends WFSTestSupport {
    private static final QName ALL_TYPES = new QName(MockData.CITE_URI, "AllTypes", MockData.CITE_PREFIX);
    private static final QName ALL_DOTS = new QName(MockData.CITE_URI, "All.Types.Dots", MockData.CITE_PREFIX);
    private static final QName GEOMMID = new QName(MockData.CITE_URI, "geommid", MockData.CITE_PREFIX);
    private static final QName LONGNAMES = new QName(MockData.CITE_URI, "longnames", MockData.CITE_PREFIX);
    private static final QName NULLGEOM = new QName(MockData.CITE_URI, "nullgeom", MockData.CITE_PREFIX);
    private static final QName DOTS = new QName(MockData.CITE_URI, "dots.in.name", MockData.CITE_PREFIX);
    private Operation op;
    private GetFeatureType gft;

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("srs", "4326");
        dataDirectory.addPropertiesType(ALL_TYPES, ShapeZipTest.class.getResource("AllTypes.properties"), params);
        dataDirectory.addPropertiesType(ALL_DOTS, ShapeZipTest.class.getResource("All.Types.Dots.properties"), params);
        dataDirectory.addPropertiesType(GEOMMID, ShapeZipTest.class.getResource("geommid.properties"), params);
        dataDirectory.addPropertiesType(NULLGEOM, ShapeZipTest.class.getResource("nullgeom.properties"), params);
        dataDirectory.addPropertiesType(DOTS, ShapeZipTest.class.getResource("dots.in.name.properties"), params);
        dataDirectory.addPropertiesType(LONGNAMES, ShapeZipTest.class.getResource("longnames.properties"), params);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.gft = WfsFactory.eINSTANCE.createGetFeatureType();
        this.op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{this.gft});
    }

    public void testNoNativeProjection() throws Exception {
        byte[] zip = this.writeOut(this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures());
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(zip));
    }

    public void testCharset() throws Exception {
        FeatureSource fs = this.getFeatureSource(MockData.BASIC_POLYGONS);
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fs.getFeatures());
        HashMap<String, Charset> options = new HashMap<String, Charset>();
        options.put("CHARSET", Charset.forName("ISO-8859-15"));
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(bos.toByteArray()));
        ShapeZipTest.assertEquals((String)"ISO-8859-15", (String)this.getCharset(new ByteArrayInputStream(bos.toByteArray())));
    }

    public void testMultiType() throws Exception {
        byte[] zip = this.writeOut(this.getFeatureSource(ALL_TYPES).getFeatures());
        String[] expectedTypes = new String[]{"AllTypesPoint", "AllTypesMPoint", "AllTypesPolygon", "AllTypesLine"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    public void testMultiTypeDots() throws Exception {
        byte[] zip = this.writeOut(this.getFeatureSource(ALL_DOTS).getFeatures());
        String[] expectedTypes = new String[]{"All_Types_DotsPoint", "All_Types_DotsMPoint", "All_Types_DotsPolygon", "All_Types_DotsLine"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    public void testGeometryInTheMiddle() throws Exception {
        byte[] zip = this.writeOut(this.getFeatureSource(GEOMMID).getFeatures());
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    public void testNullGeometries() throws Exception {
        byte[] zip = this.writeOut(this.getFeatureSource(NULLGEOM).getFeatures());
        String[] expectedTypes = new String[]{"nullgeom"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
    }

    public void testLongNames() throws Exception {
        byte[] zip = this.writeOut(this.getFeatureSource(LONGNAMES).getFeatures());
        SimpleFeatureType schema = this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
        this.checkLongNamesSchema(schema);
        zip = this.writeOut(this.getFeatureSource(LONGNAMES).getFeatures());
        schema = this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
        this.checkLongNamesSchema(schema);
    }

    void checkLongNamesSchema(SimpleFeatureType schema) {
        ShapeZipTest.assertEquals((int)4, (int)schema.getAttributeCount());
        ShapeZipTest.assertEquals((String)"the_geom", (String)schema.getDescriptor(0).getName().getLocalPart());
        ShapeZipTest.assertEquals(MultiPolygon.class, (Object)schema.getDescriptor(0).getType().getBinding());
        ShapeZipTest.assertEquals((String)"FID", (String)schema.getDescriptor(1).getName().getLocalPart());
        ShapeZipTest.assertEquals((String)"VERYLONGNA", (String)schema.getDescriptor(2).getName().getLocalPart());
        ShapeZipTest.assertEquals((String)"VERYLONGN0", (String)schema.getDescriptor(3).getName().getLocalPart());
    }

    public void testDots() throws Exception {
        byte[] zip = this.writeOut(this.getFeatureSource(DOTS).getFeatures());
        String[] expectedTypes = new String[]{"dots_in_name"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    public void testEmptyResult() throws Exception {
        byte[] zip = this.writeOut(this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures((Filter)Filter.EXCLUDE));
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(zip));
    }

    public void testEmptyResulMultiGeom() throws Exception {
        ZipEntry entry;
        byte[] zip = this.writeOut(this.getFeatureSource(ALL_DOTS).getFeatures((Filter)Filter.EXCLUDE));
        String[] expectedTypes = new String[]{"All_Types_Dots"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        boolean foundReadme = false;
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
        while ((entry = zis.getNextEntry()) != null) {
            foundReadme |= entry.getName().equals("README.TXT");
        }
    }

    byte[] writeOut(FeatureCollection fc) throws IOException {
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fc);
        zip.write(fct, (OutputStream)bos, this.op);
        return bos.toByteArray();
    }

    private File createTempFolder(String prefix) throws IOException {
        File temp = File.createTempFile(prefix, null);
        temp.delete();
        temp.mkdir();
        return temp;
    }

    private void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        int count = 0;
        byte[] buf = new byte[8192];
        while ((count = inStream.read(buf, 0, 8192)) != -1) {
            outStream.write(buf, 0, count);
        }
    }

    private SimpleFeatureType checkFieldsAreNotEmpty(InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        File tempFolder = this.createTempFolder("shp_");
        String shapeFileName = "";
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            String outName = String.valueOf(tempFolder.getAbsolutePath()) + File.separatorChar + name;
            if (name.toLowerCase().endsWith("shp")) {
                shapeFileName = outName;
            }
            FileOutputStream outFile = new FileOutputStream(outName);
            this.copyStream(zis, outFile);
            outFile.close();
            zis.closeEntry();
        }
        zis.close();
        File shapeFile = new File(shapeFileName);
        ShapefileDataStore ds = new ShapefileDataStore(shapeFile.toURL());
        FeatureSource fs = ds.getFeatureSource();
        FeatureCollection fc = fs.getFeatures();
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        Iterator iter = fc.iterator();
        try {
            while (iter.hasNext()) {
                SimpleFeature f = (SimpleFeature)iter.next();
                for (Object attrValue : f.getAttributes()) {
                    ShapeZipTest.assertNotNull(attrValue);
                    if (Geometry.class.isAssignableFrom(attrValue.getClass())) {
                        ShapeZipTest.assertFalse((String)"Empty geometry", (boolean)((Geometry)attrValue).isEmpty());
                        continue;
                    }
                    ShapeZipTest.assertFalse((String)"Empty value for attribute", (boolean)attrValue.toString().trim().equals(""));
                }
            }
        }
        finally {
            fc.close(iter);
            tempFolder.delete();
        }
        return schema;
    }

    private void checkShapefileIntegrity(String[] typeNames, InputStream in) throws IOException {
        String name;
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        String[] extensions = new String[]{".shp", ".shx", ".dbf", ".prj", ".cst"};
        HashSet<String> names = new HashSet<String>();
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            String[] stringArray2 = extensions;
            int n3 = extensions.length;
            int n4 = 0;
            while (n4 < n3) {
                String extension = stringArray2[n4];
                names.add(String.valueOf(name) + extension);
                ++n4;
            }
            ++n2;
        }
        while ((entry = zis.getNextEntry()) != null) {
            name = entry.getName();
            ShapeZipTest.assertTrue((String)("Missing " + name), (boolean)names.contains(name));
            names.remove(name);
            zis.closeEntry();
        }
        zis.close();
    }

    private String getCharset(InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        byte[] bytes = new byte[1024];
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().endsWith(".cst")) continue;
            zis.read(bytes);
        }
        zis.close();
        if (bytes == null) {
            // empty if block
        }
        return new String(bytes).trim();
    }
}

