/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescribeFeatureTypeTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new DescribeFeatureTypeTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableDataStore(MockData.CITE_PREFIX);
    }

    public void testDateMappings() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"" + MockData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "\">" + " <wfs:TypeName>sf:" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName>" + "</wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        NodeList elements = doc.getElementsByTagName("xsd:element");
        boolean date = false;
        boolean dateTime = false;
        int i = 0;
        while (i < elements.getLength()) {
            Element e = (Element)elements.item(i);
            if ("dateProperty".equals(e.getAttribute("name"))) {
                date = "xsd:date".equals(e.getAttribute("type"));
            }
            if ("dateTimeProperty".equals(e.getAttribute("name"))) {
                dateTime = "xsd:dateTime".equals(e.getAttribute("type"));
            }
            ++i;
        }
        DescribeFeatureTypeTest.assertTrue((boolean)date);
        DescribeFeatureTypeTest.assertTrue((boolean)dateTime);
    }

    public void testNoNamespaceDeclaration() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:TypeName>sf:" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName>" + "</wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testMultipleTypesImport() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"" + MockData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "\">" + "<wfs:TypeName>sf:" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName>" + "<wfs:TypeName>sf:" + MockData.GENERICENTITY.getLocalPart() + "</wfs:TypeName>" + "</wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        this.print(doc);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        boolean seenComplexType = false;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("xsd:complexType")) {
                seenComplexType = true;
            } else if (seenComplexType && node.getNodeName().equals("xsd:import")) {
                DescribeFeatureTypeTest.fail((String)"All xsd:import must occur before all xsd:complexType");
            }
            ++i;
        }
    }
}

