/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.apache.commons.io.FileUtils;
import org.geoserver.data.util.IOUtils;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.response.RemappingFeatureCollection;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeZipOutputFormat
extends WFSGetFeatureOutputFormat
implements ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(ShapeZipOutputFormat.class);
    private String outputFileName;
    private ApplicationContext applicationContext;

    public ShapeZipOutputFormat() {
        super("SHAPE-ZIP");
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/zip";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "SHAPE-ZIP";
    }

    @Override
    protected boolean canHandleInternal(Operation operation) {
        GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureType.class);
        this.outputFileName = ((QName)((QueryType)request.getQuery().get(0)).getTypeName().get(0)).getLocalPart();
        return true;
    }

    public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
        return new String[][]{{"Content-Disposition", "attachment; filename=" + this.outputFileName + ".zip"}};
    }

    @Override
    protected void write(FeatureCollectionType featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        File tempDir = IOUtils.createTempDirectory((String)"wfsshptemp");
        Charset charset = this.getShapefileCharset(getFeature);
        try {
            Iterator outputFeatureCollections = featureCollection.getFeature().iterator();
            boolean shapefileCreated = false;
            while (outputFeatureCollections.hasNext()) {
                FeatureCollection curCollection = (FeatureCollection)outputFeatureCollections.next();
                if (((SimpleFeatureType)curCollection.getSchema()).getGeometryDescriptor() == null) {
                    throw new WFSException("Cannot write geometryless shapefiles, yet " + curCollection.getSchema() + " has no geometry field");
                }
                Class geomType = ((SimpleFeatureType)curCollection.getSchema()).getGeometryDescriptor().getType().getBinding();
                if (GeometryCollection.class.equals((Object)geomType) || Geometry.class.equals((Object)geomType)) {
                    shapefileCreated |= this.writeCollectionToShapefiles((FeatureCollection<SimpleFeatureType, SimpleFeature>)curCollection, tempDir, charset);
                    continue;
                }
                this.writeCollectionToShapefile((FeatureCollection<SimpleFeatureType, SimpleFeature>)curCollection, tempDir, charset);
                shapefileCreated = true;
            }
            if (!shapefileCreated) {
                FeatureCollection<SimpleFeatureType, SimpleFeature> fc = (FeatureCollection<SimpleFeatureType, SimpleFeature>)featureCollection.getFeature().iterator().next();
                fc = this.remapCollectionSchema(fc, Point.class);
                this.writeCollectionToShapefile(fc, tempDir, this.getShapefileCharset(getFeature));
                this.createEmptyZipWarning(tempDir);
            }
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".shp") || name.endsWith(".shx") || name.endsWith(".dbf") || name.endsWith(".prj") || name.endsWith(".cst");
                }
            };
            ZipOutputStream zipOut = new ZipOutputStream(output);
            IOUtils.zipDirectory((File)tempDir, (ZipOutputStream)zipOut, (FilenameFilter)filter);
            zipOut.finish();
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)tempDir);
            }
            catch (IOException e) {
                LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath() + " due to: " + e.getMessage());
            }
        }
    }

    private void createEmptyZipWarning(File tempDir) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new File(tempDir, "README.TXT"));
            pw.print("The query result is empty, and the geometric type of the features is unknwon:an empty point shapefile has been created to fill the zip file");
        }
        finally {
            pw.close();
        }
    }

    private void writeCollectionToShapefile(FeatureCollection<SimpleFeatureType, SimpleFeature> c, File tempDir, Charset charset) {
        SimpleFeatureType schema = (SimpleFeatureType)(c = this.remapCollectionSchema((FeatureCollection<SimpleFeatureType, SimpleFeature>)c, null)).getSchema();
        if (schema.getTypeName().contains(".")) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init((SimpleFeatureType)c.getSchema());
            tb.setName(((SimpleFeatureType)c.getSchema()).getTypeName().replace('.', '_'));
            SimpleFeatureType renamed = tb.buildFeatureType();
            c = new RetypingFeatureCollection(c, renamed);
        }
        FeatureStore fstore = null;
        ShapefileDataStore dstore = null;
        try {
            try {
                Map<String, String> attributeMappings = this.createAttributeMappings((SimpleFeatureType)c.getSchema());
                RemappingFeatureCollection remapped = new RemappingFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)c, attributeMappings);
                SimpleFeatureType remappedSchema = (SimpleFeatureType)remapped.getSchema();
                dstore = this.buildStore(tempDir, charset, remappedSchema);
                fstore = (FeatureStore)dstore.getFeatureSource();
                RetypingFeatureCollection retyped = new RetypingFeatureCollection((FeatureCollection)remapped, (SimpleFeatureType)fstore.getSchema());
                fstore.addFeatures((FeatureCollection)retyped);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
                throw new ServiceException((Throwable)ioe);
            }
        }
        finally {
            if (dstore != null) {
                dstore.dispose();
            }
        }
    }

    FeatureCollection<SimpleFeatureType, SimpleFeature> remapCollectionSchema(FeatureCollection<SimpleFeatureType, SimpleFeature> fc, Class targetGeometry) {
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        if (schema.getTypeName().contains(".")) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            if (targetGeometry == null) {
                tb.init(schema);
            } else {
                for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
                    if (!(ad instanceof GeometryDescriptor)) {
                        tb.add(ad);
                        continue;
                    }
                    Class geomType = ad.getType().getBinding();
                    if (geomType.equals(Geometry.class) || geomType.equals(GeometryCollection.class)) {
                        tb.add(ad.getName().getLocalPart(), targetGeometry, ((GeometryDescriptor)ad).getCoordinateReferenceSystem());
                        continue;
                    }
                    tb.add(ad);
                }
            }
            tb.setName(((SimpleFeatureType)fc.getSchema()).getTypeName().replace('.', '_'));
            SimpleFeatureType renamed = tb.buildFeatureType();
            fc = new RetypingFeatureCollection(fc, renamed);
        }
        Map<String, String> attributeMappings = this.createAttributeMappings(schema);
        return new RemappingFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)fc, attributeMappings);
    }

    private Map<String, String> createAttributeMappings(SimpleFeatureType schema) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> usedFieldNames = new HashSet<String>();
        usedFieldNames.add("the_geom");
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (attDesc instanceof GeometryDescriptor) {
                result.put(attDesc.getLocalName(), "the_geom");
                continue;
            }
            String name = attDesc.getLocalName();
            result.put(attDesc.getLocalName(), this.getShapeCompatibleName(usedFieldNames, name));
        }
        return result;
    }

    String getShapeCompatibleName(Set<String> usedFieldNames, String name) {
        if (name.length() > 10) {
            name = name.substring(0, 10);
        }
        int counter = 0;
        while (usedFieldNames.contains(name)) {
            String postfix = String.valueOf(counter++);
            name = String.valueOf(name.substring(0, name.length() - postfix.length())) + postfix;
        }
        usedFieldNames.add(name);
        return name;
    }

    /*
     * Unable to fully structure code
     */
    private boolean writeCollectionToShapefiles(FeatureCollection<SimpleFeatureType, SimpleFeature> c, File tempDir, Charset charset) {
        c = this.remapCollectionSchema(c, null);
        schema = (SimpleFeatureType)c.getSchema();
        shapefileCreated = false;
        writers = new HashMap<Class, StoreWriter>();
        try {
            try {
                it = c.features();
                while (it.hasNext()) {
                    f = (SimpleFeature)it.next();
                    if (f.getDefaultGeometry() == null) {
                        ShapeZipOutputFormat.LOGGER.warning("Skipping " + f.getID() + " as its geometry is null");
                        continue;
                    }
                    writer = this.getFeatureWriter(f, writers, tempDir, charset);
                    fw = (SimpleFeature)writer.next();
                    for (AttributeDescriptor d : fw.getFeatureType().getAttributeDescriptors()) {
                        fw.setAttribute(d.getLocalName(), f.getAttribute(d.getLocalName()));
                    }
                    fw.setDefaultGeometry(f.getDefaultGeometry());
                    writer.write();
                    shapefileCreated = true;
                }
            }
            catch (IOException ioe) {
                ShapeZipOutputFormat.LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
                throw new ServiceException((Throwable)ioe);
            }
        }
        finally {
            stored = null;
            ** for (sw : writers.values())
        }
lbl-1000:
        // 1 sources

        {
            try {
                sw.writer.close();
                sw.dstore.dispose();
            }
            catch (IOException e) {
                stored = e;
            }
            continue;
        }
lbl36:
        // 1 sources

        if (stored != null) {
            throw new ServiceException(stored);
        }
        return shapefileCreated;
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(SimpleFeature f, Map<Class, StoreWriter> writers, File tempDir, Charset charset) throws IOException {
        Class<Point> target;
        Geometry g = (Geometry)f.getDefaultGeometry();
        String suffix = null;
        if (g instanceof Point) {
            target = Point.class;
            suffix = "Point";
        } else if (g instanceof MultiPoint) {
            target = MultiPoint.class;
            suffix = "MPoint";
        } else if (g instanceof MultiPolygon || g instanceof Polygon) {
            target = MultiPolygon.class;
            suffix = "Polygon";
        } else if (g instanceof LineString || g instanceof MultiLineString) {
            target = MultiLineString.class;
            suffix = "Line";
        } else {
            throw new RuntimeException("This should never happen, there's a bug in the SHAPE-ZIP output format. I got a geometry of type " + g.getClass());
        }
        StoreWriter storeWriter = writers.get(target);
        if (storeWriter == null) {
            SimpleFeatureType original = f.getFeatureType();
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor d : original.getAttributeDescriptors()) {
                if (Geometry.class.isAssignableFrom(d.getType().getBinding())) {
                    GeometryDescriptor gd = (GeometryDescriptor)d;
                    builder.add(gd.getLocalName(), target, gd.getCoordinateReferenceSystem());
                    builder.setDefaultGeometry(gd.getLocalName());
                    continue;
                }
                builder.add(d);
            }
            builder.setName(String.valueOf(original.getTypeName().replace('.', '_')) + suffix);
            builder.setNamespaceURI(original.getName().getURI());
            SimpleFeatureType retyped = builder.buildFeatureType();
            ShapefileDataStore dstore = this.buildStore(tempDir, charset, retyped);
            storeWriter = new StoreWriter();
            storeWriter.dstore = dstore;
            storeWriter.writer = dstore.getFeatureWriter(retyped.getTypeName(), Transaction.AUTO_COMMIT);
            writers.put(target, storeWriter);
        }
        return storeWriter.writer;
    }

    private Charset getShapefileCharset(Operation getFeature) {
        Charset result = null;
        GetFeatureType gft = (GetFeatureType)getFeature.getParameters()[0];
        if (gft.getFormatOptions() != null && gft.getFormatOptions().get("CHARSET") != null) {
            result = (Charset)gft.getFormatOptions().get("CHARSET");
        } else {
            String charsetName = GeoServerExtensions.getProperty((String)"GS-SHAPEFILE-CHARSET", (ApplicationContext)this.applicationContext);
            if (charsetName != null) {
                result = Charset.forName(charsetName);
            }
        }
        return result != null ? result : Charset.forName("ISO-8859-1");
    }

    private ShapefileDataStore buildStore(File tempDir, Charset charset, SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
        File file = new File(tempDir, String.valueOf(schema.getTypeName()) + ".shp");
        ShapefileDataStore sfds = new ShapefileDataStore(file.toURL());
        sfds.setStringCharset(charset);
        File charsetFile = new File(tempDir, String.valueOf(schema.getTypeName()) + ".cst");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(charsetFile);
            pw.write(charset.name());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        try {
            sfds.createSchema(schema);
        }
        catch (NullPointerException e) {
            LOGGER.warning("Error in shapefile schema. It is possible you don't have a geometry set in the output. \nPlease specify a <wfs:PropertyName>geom_column_name</wfs:PropertyName> in the request");
            throw new ServiceException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
        }
        try {
            if (schema.getCoordinateReferenceSystem() != null) {
                sfds.forceSchemaCRS(schema.getCoordinateReferenceSystem());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not properly create the .prj file", e);
        }
        return sfds;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class StoreWriter {
        DataStore dstore;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;

        private StoreWriter() {
        }
    }
}

