/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAccessManagerWFSTest
extends WFSTestSupport {
    static final String INSERT_RESTRICTED_STREET = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:cite=\"http://www.opengis.net/cite\"\n  xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.0.0/WFS-transaction.xsd http://www.openplans.org/topp http://localhost:8080/geoserver/wfs/DescribeFeatureType?typename=topp:tasmania_roads\">\n  <wfs:Insert>\n    <cite:Buildings fid=\"Buildings.123\">\n      <cite:the_geom>\n        <gml:MultiPolygon srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n          <gml:polygonMember>\n            <gml:Polygon>\n              <gml:outerBoundaryIs>\n                <gml:LinearRing>\n                  <gml:coordinates cs=\",\" decimal=\".\"\n                    ts=\" \" xmlns:gml=\"http://www.opengis.net/gml\">0.0020,0.0008 0.0020,0.0010\n                    0.0024,0.0010 0.0024,0.0008 0.0020,0.0008</gml:coordinates>\n                </gml:LinearRing>\n              </gml:outerBoundaryIs>\n            </gml:Polygon>\n          </gml:polygonMember>\n        </gml:MultiPolygon>\n      </cite:the_geom>\n      <cite:FID>151</cite:FID>\n      <cite:ADDRESS>123 Restricted Street</cite:ADDRESS>\n    </cite:Buildings>\n  </wfs:Insert>\n</wfs:Transaction>";
    static final String UPDATE_ADDRESS = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"\n  xmlns:cite=\"http://www.opengis.net/cite\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\">\n  <wfs:Update typeName=\"cite:Buildings\">\n    <wfs:Property>\n      <wfs:Name>ADDRESS</wfs:Name>\n      <wfs:Value>123 ABC Street</wfs:Value>\n    </wfs:Property>\n  </wfs:Update>\n</wfs:Transaction>";
    static final String DELETE_ADDRESS = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"\n  xmlns:cite=\"http://www.opengis.net/cite\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\">\n  <wfs:Delete typeName=\"cite:Buildings\">  <ogc:Filter>\n    <ogc:BBOX>\n        <ogc:PropertyName>the_geom</ogc:PropertyName>\n        <gml:Envelope srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n           <gml:lowerCorner>-180 -90</gml:lowerCorner>\n           <gml:upperCorner>180 90</gml:upperCorner>\n        </gml:Envelope>\n      </ogc:BBOX>\n  </ogc:Filter>\n  </wfs:Delete>\n</wfs:Transaction>";

    protected String[] getSpringContextLocations() {
        String[] base = super.getSpringContextLocations();
        String[] extended = new String[base.length + 1];
        System.arraycopy(base, 0, extended, 0, base.length);
        extended[base.length] = "classpath:/org/geoserver/wfs/ResourceAccessManagerContext.xml";
        return extended;
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        File security = new File(dataDirectory.getDataDirectoryRoot(), "security");
        security.mkdir();
        File users = new File(security, "users.properties");
        Properties props = new Properties();
        props.put("admin", "geoserver,ROLE_ADMINISTRATOR");
        props.put("cite", "cite,ROLE_DUMMY");
        props.put("cite_readfilter", "cite,ROLE_DUMMY");
        props.put("cite_readatts", "cite,ROLE_DUMMY");
        props.put("cite_insertfilter", "cite,ROLE_DUMMY");
        props.put("cite_writefilter", "cite,ROLE_DUMMY");
        props.put("cite_writeatts", "cite,ROLE_DUMMY");
        props.store(new FileOutputStream(users), "");
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo buildings = catalog.getFeatureTypeByName(this.getLayerId(MockData.BUILDINGS));
        PropertyIsEqualTo fid113 = ff.equal((Expression)ff.property("FID"), (Expression)ff.literal((Object)"113"), false);
        tam.putLimits("cite_readfilter", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)fid113, null, null));
        List<PropertyName> readAtts = Arrays.asList(ff.property("the_geom"), ff.property("FID"));
        tam.putLimits("cite_readatts", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, readAtts, (Filter)fid113, null, null));
        Not restrictedStreet = ff.not((Filter)ff.like((Expression)ff.property("ADDRESS"), "*Restricted Street*", "*", "?", "\\"));
        tam.putLimits("cite_insertfilter", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, null, null, (Filter)restrictedStreet));
        tam.putLimits("cite_writefilter", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, null, null, (Filter)fid113));
        List<PropertyName> writeAtts = Arrays.asList(ff.property("the_geom"), ff.property("FID"));
        tam.putLimits("cite_writeatts", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, null, writeAtts, null));
    }

    public void testNoLimits() throws Exception {
        this.authenticate("cite", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//cite:Buildings)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//cite:ADDRESS)", (Document)doc);
    }

    public void testReadFilter() throws Exception {
        this.authenticate("cite_readfilter", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:FID", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:ADDRESS)", (Document)doc);
    }

    public void testFilterAttribute() throws Exception {
        this.authenticate("cite_readatts", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:FID", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cite:ADDRESS)", (Document)doc);
    }

    public void testInsertNoLimits() throws Exception {
        this.authenticate("cite", "cite");
        Document dom = this.postAsDOM("wfs", INSERT_RESTRICTED_STREET);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:WFS_TransactionResponse)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:FeatureId)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"new0", (String)"//ogc:FeatureId/@fid", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:Status/wfs:SUCCESS)", (Document)dom);
    }

    public void testInsertRestricted() throws Exception {
        this.authenticate("cite_insertfilter", "cite");
        Document dom = this.postAsDOM("wfs", INSERT_RESTRICTED_STREET);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:WFS_TransactionResponse)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:Status/wfs:FAILED)", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String message = xpath.evaluate("//wfs:Message", dom);
        ResourceAccessManagerWFSTest.assertTrue((boolean)message.matches(".*write restrictions.*"));
    }

    public void testInsertAttributeRestricted() throws Exception {
        this.authenticate("cite_writeatts", "cite");
        Document dom = this.postAsDOM("wfs", INSERT_RESTRICTED_STREET);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:WFS_TransactionResponse)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:Status/wfs:FAILED)", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String message = xpath.evaluate("//wfs:Message", dom);
        ResourceAccessManagerWFSTest.assertTrue((boolean)message.matches(".*write protected.*ADDRESS.*"));
    }

    public void testUpdateNoLimits() throws Exception {
        this.authenticate("cite", "cite");
        Document dom = this.postAsDOM("wfs", UPDATE_ADDRESS);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"//wfs:totalUpdated", (Document)dom);
    }

    public void testUpdateLimitWrite() throws Exception {
        this.authenticate("cite_writefilter", "cite");
        Document dom = this.postAsDOM("wfs", UPDATE_ADDRESS);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated", (Document)dom);
        this.authenticate("cite", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"123 ABC Street", (String)"//cite:Buildings[cite:FID = '113']/cite:ADDRESS", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"215 Main Street", (String)"//cite:Buildings[cite:FID = '114']/cite:ADDRESS", (Document)doc);
    }

    public void testUpdateAttributeRestricted() throws Exception {
        this.authenticate("cite_writeatts", "cite");
        Document dom = this.postAsDOM("wfs", UPDATE_ADDRESS);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String message = xpath.evaluate("//ows:ExceptionText", dom);
        ResourceAccessManagerWFSTest.assertTrue((boolean)message.matches(".*write protected.*ADDRESS.*"));
    }

    public void testDeleteLimitWrite() throws Exception {
        this.authenticate("cite_writefilter", "cite");
        Document dom = this.postAsDOM("wfs", DELETE_ADDRESS);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalDeleted", (Document)dom);
        this.authenticate("cite", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cite:Buildings[cite:FID = '113'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings[cite:FID = '114'])", (Document)doc);
    }
}

