/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Geometry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.config.GeoServer;
import org.geoserver.feature.ReprojectingFeatureCollection;
import org.geoserver.wfs.AbstractTransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTransactionException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InsertElementHandler
extends AbstractTransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    private FilterFactory filterFactory;

    public InsertElementHandler(GeoServer gs, FilterFactory filterFactory) {
        super(gs);
        this.filterFactory = filterFactory;
    }

    public void checkValidity(EObject element, Map featureTypeInfos) throws WFSTransactionException {
        if (!this.getInfo().getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
            throw new WFSException("Transaction INSERT support is not enabled");
        }
    }

    public void execute(EObject element, TransactionType request, Map featureStores, TransactionResponseType response, TransactionListener listener) throws WFSTransactionException {
        LOGGER.finer("Transasction Insert:" + element);
        InsertElementType insert = (InsertElementType)element;
        long inserted = response.getTransactionSummary().getTotalInserted().longValue();
        try {
            HashMap<SimpleFeatureType, SimpleFeatureCollection> schema2features = new HashMap<SimpleFeatureType, SimpleFeatureCollection>();
            for (SimpleFeature feature : insert.getFeature()) {
                SimpleFeatureType schema = feature.getFeatureType();
                SimpleFeatureCollection collection = (SimpleFeatureCollection)schema2features.get(schema);
                if (collection == null) {
                    collection = new DefaultFeatureCollection(null, schema);
                    schema2features.put(schema, collection);
                }
                collection.add((Feature)feature);
            }
            HashMap schema2fids = new HashMap();
            for (SimpleFeatureCollection collection : schema2features.values()) {
                CoordinateReferenceSystem target;
                GeometryDescriptor defaultGeometry;
                SimpleFeatureType schema = (SimpleFeatureType)collection.getSchema();
                QName elementName = new QName(schema.getName().getNamespaceURI(), schema.getTypeName());
                SimpleFeatureStore store = DataUtilities.simple((FeatureStore)((FeatureStore)featureStores.get(elementName)));
                if (store == null) {
                    throw new WFSException("Could not locate FeatureStore for '" + elementName + "'");
                }
                if (collection == null) continue;
                if (this.getInfo().isCiteCompliant()) {
                    this.checkFeatureCoordinatesRange(collection);
                }
                if ((defaultGeometry = ((SimpleFeatureType)store.getSchema()).getGeometryDescriptor()) != null && (target = defaultGeometry.getCoordinateReferenceSystem()) != null) {
                    collection = new ReprojectingFeatureCollection(collection, target);
                }
                LOGGER.finer("Use featureValidation to check contents of insert");
                LinkedList fids = (LinkedList)schema2fids.get(schema.getTypeName());
                if (fids == null) {
                    fids = new LinkedList();
                    schema2fids.put(schema.getTypeName(), fids);
                }
                TransactionEvent event = new TransactionEvent(TransactionEventType.PRE_INSERT, elementName, collection);
                event.setSource(insert);
                listener.dataStoreChange(event);
                fids.addAll(store.addFeatures((FeatureCollection)collection));
            }
            InsertedFeatureType insertedFeature = null;
            for (SimpleFeature feature : insert.getFeature()) {
                SimpleFeatureType schema = feature.getFeatureType();
                LinkedList fids = (LinkedList)schema2fids.get(schema.getTypeName());
                String fid = ((FeatureId)fids.removeFirst()).getID();
                insertedFeature = WfsFactory.eINSTANCE.createInsertedFeatureType();
                insertedFeature.setHandle(insert.getHandle());
                insertedFeature.getFeatureId().add((Object)this.filterFactory.featureId(fid));
                response.getInsertResults().getFeature().add((Object)insertedFeature);
            }
        }
        catch (Exception e) {
            String msg = "Error performing insert: " + e.getMessage();
            throw new WFSTransactionException(msg, e, insert.getHandle());
        }
        response.getTransactionSummary().setTotalInserted(BigInteger.valueOf(inserted += (long)insert.getFeature().size()));
    }

    void checkFeatureCoordinatesRange(SimpleFeatureCollection collection) throws PointOutsideEnvelopeException {
        List types = ((SimpleFeatureType)collection.getSchema()).getAttributeDescriptors();
        SimpleFeatureIterator fi = collection.features();
        try {
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                int i = 0;
                while (i < types.size()) {
                    Geometry geom;
                    GeometryDescriptor gat;
                    if (types.get(i) instanceof GeometryDescriptor && (gat = (GeometryDescriptor)types.get(i)).getCoordinateReferenceSystem() != null && (geom = (Geometry)f.getAttribute(i)) != null) {
                        JTS.checkCoordinatesRange((Geometry)geom, (CoordinateReferenceSystem)gat.getCoordinateReferenceSystem());
                    }
                    ++i;
                }
            }
        }
        finally {
            fi.close();
        }
    }

    public Class getElementClass() {
        return InsertElementType.class;
    }

    public QName[] getTypeNames(EObject element) throws WFSTransactionException {
        InsertElementType insert = (InsertElementType)element;
        ArrayList<QName> typeNames = new ArrayList<QName>();
        if (!insert.getFeature().isEmpty()) {
            for (SimpleFeature feature : insert.getFeature()) {
                String name = feature.getFeatureType().getTypeName();
                String namespaceURI = feature.getFeatureType().getName().getNamespaceURI();
                typeNames.add(new QName(namespaceURI, name));
            }
        } else {
            LOGGER.finer("Insert was empty - does not need a FeatuerSoruce");
        }
        return typeNames.toArray(new QName[typeNames.size()]);
    }
}

