/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.PropertyType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.AbstractTransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.WFSTransactionException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class UpdateElementHandler
extends AbstractTransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");

    public UpdateElementHandler(GeoServer gs) {
        super(gs);
    }

    public void checkValidity(EObject element, Map typeInfos) throws WFSTransactionException {
        if (!this.getInfo().getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
            throw new WFSException("Transaction Update support is not enabled");
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        UpdateElementType update = (UpdateElementType)element;
        try {
            FeatureTypeInfo meta = (FeatureTypeInfo)typeInfos.values().iterator().next();
            FeatureType featureType = meta.getFeatureType();
            for (PropertyType property : update.getProperty()) {
                if (property.getValue() == null) {
                    String propertyName = property.getName().getLocalPart();
                    AttributeDescriptor attributeType = null;
                    PropertyDescriptor pd = featureType.getDescriptor(propertyName);
                    if (pd instanceof AttributeDescriptor) {
                        attributeType = (AttributeDescriptor)pd;
                    }
                    if (attributeType != null && attributeType.getMinOccurs() > 0) {
                        String msg = "Property '" + attributeType.getLocalName() + "' is mandatory but no value specified.";
                        throw new WFSException(msg, "MissingParameterValue");
                    }
                }
                QName name = property.getName();
                PropertyName propertyName = null;
                propertyName = name.getPrefix() != null && !"".equals(name.getPrefix()) ? ff.property(String.valueOf(name.getPrefix()) + ":" + name.getLocalPart()) : ff.property(name.getLocalPart());
                if (propertyName.evaluate((Object)featureType) != null) continue;
                String msg = "No such property: " + property.getName();
                throw new WFSException(msg);
            }
        }
        catch (IOException e) {
            throw new WFSTransactionException("Could not locate feature type information for " + update.getTypeName(), e, update.getHandle());
        }
    }

    public void execute(EObject element, TransactionType request, Map featureStores, TransactionResponseType response, TransactionListener listener) throws WFSTransactionException {
        HashSet<String> fids;
        UpdateElementType update = (UpdateElementType)element;
        QName elementName = update.getTypeName();
        String handle = update.getHandle();
        long updated = response.getTransactionSummary().getTotalUpdated().longValue();
        SimpleFeatureStore store = DataUtilities.simple((FeatureStore)((FeatureStore)featureStores.get(elementName)));
        if (store == null) {
            throw new WFSException("Could not locate FeatureStore for '" + elementName + "'");
        }
        LOGGER.finer("Transaction Update:" + element);
        try {
            Object filter = update.getFilter();
            CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(store.getSchema(), request.getVersion());
            filter = filter != null ? WFSReprojectionUtil.normalizeFilterCRS(filter, store.getSchema(), declaredCRS) : Filter.INCLUDE;
            AttributeDescriptor[] types = new AttributeDescriptor[update.getProperty().size()];
            String[] names = new String[update.getProperty().size()];
            Object[] values = new Object[update.getProperty().size()];
            int j = 0;
            while (j < update.getProperty().size()) {
                PropertyType property = (PropertyType)update.getProperty().get(j);
                types[j] = ((SimpleFeatureType)store.getSchema()).getDescriptor(property.getName().getLocalPart());
                names[j] = property.getName().getLocalPart();
                values[j] = property.getValue();
                if (values[j] instanceof Geometry) {
                    Geometry geometry = (Geometry)values[j];
                    CoordinateReferenceSystem source = null;
                    if (geometry.getUserData() instanceof CoordinateReferenceSystem) {
                        source = (CoordinateReferenceSystem)geometry.getUserData();
                    } else {
                        geometry.setUserData((Object)declaredCRS);
                        source = declaredCRS;
                    }
                    CoordinateReferenceSystem target = null;
                    if (types[j] instanceof GeometryDescriptor) {
                        target = ((GeometryDescriptor)types[j]).getCoordinateReferenceSystem();
                    }
                    if (this.getInfo().isCiteCompliant()) {
                        JTS.checkCoordinatesRange((Geometry)geometry, (CoordinateReferenceSystem)(source != null ? source : target));
                    }
                    if (source != null && target != null && !CRS.equalsIgnoreMetadata((Object)source, (Object)target)) {
                        try {
                            MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)true);
                            GeometryCoordinateSequenceTransformer gtx = new GeometryCoordinateSequenceTransformer();
                            gtx.setMathTransform(tx);
                            values[j] = gtx.transform(geometry);
                        }
                        catch (Exception e) {
                            String msg = "Failed to reproject geometry:" + e.getLocalizedMessage();
                            throw new WFSTransactionException(msg, e);
                        }
                    }
                }
                ++j;
            }
            fids = new HashSet<String>();
            LOGGER.finer("Preprocess to remember modification as a set of fids");
            SimpleFeatureCollection features = store.getFeatures(filter);
            TransactionEvent event = new TransactionEvent(TransactionEventType.PRE_UPDATE, elementName, features);
            event.setSource(update);
            listener.dataStoreChange(event);
            Iterator preprocess = features.iterator();
            try {
                try {
                    while (preprocess.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)preprocess.next();
                        fids.add(feature.getID());
                    }
                }
                catch (NoSuchElementException e) {
                    throw new WFSException("Could not aquire FeatureIDs", e);
                }
            }
            finally {
                features.close(preprocess);
            }
            try {
                try {
                    store.modifyFeatures(names, values, filter);
                }
                catch (Exception e) {
                    throw new WFSTransactionException("Update error: " + e.getMessage(), e, "InvalidParameterValue");
                }
            }
            finally {
                if (request.getLockId() != null && store instanceof FeatureLocking && request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                    SimpleFeatureLocking locking = (SimpleFeatureLocking)store;
                    locking.unLockFeatures(filter);
                }
            }
            if (!fids.isEmpty()) {
                LOGGER.finer("Post process update for boundary update and featureValidation");
                HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
                Iterator f = fids.iterator();
                while (f.hasNext()) {
                    featureIds.add(ff.featureId((String)f.next()));
                }
                Id modified = ff.id(featureIds);
                SimpleFeatureCollection changed = store.getFeatures((Filter)modified);
                listener.dataStoreChange(new TransactionEvent(TransactionEventType.POST_UPDATE, elementName, changed, update));
            }
        }
        catch (IOException ioException) {
            throw new WFSTransactionException(ioException, null, handle);
        }
        catch (PointOutsideEnvelopeException poe) {
            throw new WFSTransactionException(poe, null, handle);
        }
        response.getTransactionSummary().setTotalUpdated(BigInteger.valueOf(updated += (long)fids.size()));
    }

    public Class getElementClass() {
        return UpdateElementType.class;
    }

    public QName[] getTypeNames(EObject element) throws WFSTransactionException {
        return new QName[]{((UpdateElementType)element).getTypeName()};
    }
}

