/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.type.ProfileImpl;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;

public class TypeMappingProfile {
    Set profiles;

    public TypeMappingProfile(Set profiles) {
        this.profiles = profiles;
    }

    public AttributeType type(Class clazz) {
        ArrayList<AttributeType> assignable = new ArrayList<AttributeType>();
        for (ProfileImpl profile : this.profiles) {
            for (AttributeType type : profile.values()) {
                if (type.getBinding().isAssignableFrom(clazz)) {
                    assignable.add(type);
                }
                if (!clazz.equals(type.getBinding())) continue;
                return type;
            }
        }
        if (assignable.isEmpty()) {
            return null;
        }
        if (assignable.size() == 1) {
            return (AttributeType)assignable.get(0);
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Class c2;
                AttributeType a1 = (AttributeType)o1;
                AttributeType a2 = (AttributeType)o2;
                Class c1 = a1.getBinding();
                if (c1.equals(c2 = a2.getBinding())) {
                    return 0;
                }
                if (c1.isAssignableFrom(c2)) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(assignable, comparator);
        if (!assignable.get(0).equals(assignable.get(1))) {
            return (AttributeType)assignable.get(0);
        }
        return null;
    }

    public Name name(Class clazz) {
        ArrayList<Map.Entry> assignable = new ArrayList<Map.Entry>();
        for (ProfileImpl profile : this.profiles) {
            for (Map.Entry entry : profile.entrySet()) {
                AttributeType type = (AttributeType)entry.getValue();
                if (type.getBinding().isAssignableFrom(clazz)) {
                    assignable.add(entry);
                }
                if (!clazz.equals(type.getBinding())) continue;
                return (Name)entry.getKey();
            }
        }
        if (assignable.isEmpty()) {
            return null;
        }
        if (assignable.size() == 1) {
            return (Name)((Map.Entry)assignable.get(0)).getKey();
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Class c2;
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                AttributeType a1 = (AttributeType)e1.getValue();
                AttributeType a2 = (AttributeType)e2.getValue();
                Class c1 = a1.getBinding();
                if (c1.equals(c2 = a2.getBinding())) {
                    return 0;
                }
                if (c1.isAssignableFrom(c2)) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(assignable, comparator);
        Map.Entry e1 = (Map.Entry)assignable.get(0);
        Map.Entry e2 = (Map.Entry)assignable.get(1);
        AttributeType a1 = (AttributeType)e1.getValue();
        AttributeType a2 = (AttributeType)e2.getValue();
        if (!a1.equals((Object)a2)) {
            return (Name)e1.getKey();
        }
        return null;
    }
}

