/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.data.test.MockData;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListenerTester;
import org.geoserver.wfs.WFSTestSupport;
import org.opengis.feature.Feature;

public class TransactionListenerTest
extends WFSTestSupport {
    TransactionListenerTester listener;

    protected String[] getSpringContextLocations() {
        String[] base = super.getSpringContextLocations();
        String[] extended = new String[base.length + 1];
        System.arraycopy(base, 0, extended, 0, base.length);
        extended[base.length] = "classpath:/org/geoserver/wfs/TransactionListenerTestContext.xml";
        return extended;
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.listener = (TransactionListenerTester)applicationContext.getBean("transactionListenerTester");
        this.listener.clear();
    }

    public void testDelete() throws Exception {
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cgf:Points\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cgf:id</ogc:PropertyName> <ogc:Literal>t0000</ogc:Literal> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        this.postAsDOM("wfs", delete);
        TransactionListenerTest.assertEquals((int)1, (int)this.listener.events.size());
        TransactionEvent event = (TransactionEvent)this.listener.events.get(0);
        TransactionListenerTest.assertEquals((Object)TransactionEventType.PRE_DELETE, (Object)event.getType());
        TransactionListenerTest.assertEquals((Object)MockData.POINTS, (Object)event.getLayerName());
        TransactionListenerTest.assertEquals((int)1, (int)this.listener.features.size());
        Feature deleted = (Feature)this.listener.features.get(0);
        TransactionListenerTest.assertEquals((Object)"t0000", (Object)deleted.getProperty("id").getValue());
    }

    public void testInsert() throws Exception {
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert></wfs:Transaction>";
        this.postAsDOM("wfs", insert);
        TransactionListenerTest.assertEquals((int)1, (int)this.listener.events.size());
        TransactionEvent firstEvent = (TransactionEvent)this.listener.events.get(0);
        TransactionListenerTest.assertEquals((Object)TransactionEventType.PRE_INSERT, (Object)firstEvent.getType());
        TransactionListenerTest.assertEquals((Object)MockData.LINES, (Object)firstEvent.getLayerName());
        TransactionListenerTest.assertEquals((int)1, (int)this.listener.features.size());
    }

    public void testUpdate() throws Exception {
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:Polygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        this.postAsDOM("wfs", insert);
        TransactionListenerTest.assertEquals((int)2, (int)this.listener.events.size());
        TransactionEvent firstEvent = (TransactionEvent)this.listener.events.get(0);
        TransactionListenerTest.assertEquals((Object)TransactionEventType.PRE_UPDATE, (Object)firstEvent.getType());
        TransactionListenerTest.assertEquals((Object)MockData.POLYGONS, (Object)firstEvent.getLayerName());
        Feature updatedBefore = (Feature)this.listener.features.get(0);
        TransactionListenerTest.assertEquals((Object)"t0002", (Object)updatedBefore.getProperty("id").getValue());
        TransactionEvent secondEvent = (TransactionEvent)this.listener.events.get(1);
        TransactionListenerTest.assertEquals((Object)TransactionEventType.POST_UPDATE, (Object)secondEvent.getType());
        TransactionListenerTest.assertEquals((Object)MockData.POLYGONS, (Object)secondEvent.getLayerName());
        Feature updatedAfter = (Feature)this.listener.features.get(1);
        TransactionListenerTest.assertEquals((Object)"t0003", (Object)updatedAfter.getProperty("id").getValue());
        TransactionListenerTest.assertEquals((int)2, (int)this.listener.features.size());
    }
}

