/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.geoserver.wfs.response.GeoJSONBuilder;

public class GeoJSONBuilderTest
extends TestCase {
    StringWriter writer;
    GeoJSONBuilder builder;

    protected void setUp() throws Exception {
        this.writer = new StringWriter();
        this.builder = new GeoJSONBuilder((Writer)this.writer);
    }

    public void testWriteNormal() throws Exception {
        Geometry g = new WKTReader().read("MULTILINESTRING((0 0, 1 1))");
        this.builder.writeGeom(g);
        GeoJSONBuilderTest.assertEquals((String)"{\"type\":\"MultiLineString\",\"coordinates\":[[[0,0],[1,1]]]}", (String)this.writer.toString());
    }

    public void testWriteGeometrySubclass() throws Exception {
        this.builder.writeGeom((Geometry)new MyPoint(1.0, 2.0));
        GeoJSONBuilderTest.assertEquals((String)"{\"type\":\"Point\",\"coordinates\":[1,2]}", (String)this.writer.toString());
    }

    public void testWriteDate() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        java.sql.Date date = new java.sql.Date(cal.getTimeInMillis());
        this.builder.object().key("date").value((Object)date).endObject();
        GeoJSONBuilderTest.assertEquals((String)"{\"date\":\"2011-10-25Z\"}", (String)this.writer.toString());
    }

    public void testWriteTime() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        Time date = new Time(cal.getTimeInMillis());
        this.builder.object().key("time").value((Object)date).endObject();
        GeoJSONBuilderTest.assertEquals((String)"{\"time\":\"15:48:05Z\"}", (String)this.writer.toString());
    }

    public void testWriteDateTime() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        this.builder.object().key("timestamp").value((Object)date).endObject();
        GeoJSONBuilderTest.assertEquals((String)"{\"timestamp\":\"2011-10-25T15:48:05Z\"}", (String)this.writer.toString());
    }

    public void testWriteDateTimeMillis() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        cal.set(14, 223);
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        this.builder.object().key("timestamp").value((Object)date).endObject();
        GeoJSONBuilderTest.assertEquals((String)"{\"timestamp\":\"2011-10-25T15:48:05.223Z\"}", (String)this.writer.toString());
    }

    public void testWriteJavaDate() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        cal.set(14, 223);
        Date date = new Date(cal.getTimeInMillis());
        this.builder.object().key("date").value((Object)date).endObject();
        GeoJSONBuilderTest.assertEquals((String)"{\"date\":\"2011-10-25T15:48:05.223Z\"}", (String)this.writer.toString());
    }

    public void testWriteCalendar() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        this.builder.object().key("cal").value((Object)cal).endObject();
        GeoJSONBuilderTest.assertEquals((String)"{\"cal\":\"2011-10-25T00:00:00Z\"}", (String)this.writer.toString());
    }

    public void testWriteCalendarTZ() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT-05:00"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        this.builder.object().key("cal").value((Object)cal).endObject();
        GeoJSONBuilderTest.assertEquals((String)"{\"cal\":\"2011-10-25T00:00:00-05:00\"}", (String)this.writer.toString());
    }

    public void testWriteCalendarFull() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        cal.set(14, 223);
        this.builder.object().key("cal").value((Object)cal).endObject();
        GeoJSONBuilderTest.assertEquals((String)"{\"cal\":\"2011-10-25T15:48:05.223Z\"}", (String)this.writer.toString());
    }

    class MyPoint
    extends Point {
        public MyPoint(double x, double y) {
            super(new Coordinate(x, y), new PrecisionModel(), -1);
        }
    }
}

