/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.GML2Profile;
import org.geoserver.wfs.xml.GML3Profile;
import org.geoserver.wfs.xml.SchemaCleanerCallback;
import org.geoserver.wfs.xml.TypeMappingProfile;
import org.geoserver.wfs.xml.XSProfile;
import org.geotools.feature.NameImpl;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml3.v3_2.GML;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xml.Configuration;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureTypeSchemaBuilder {
    static Logger logger = Logging.getLogger((String)"org.geoserver.wfs");
    WFSInfo wfs;
    Catalog catalog;
    GeoServerResourceLoader resourceLoader;
    protected List profiles;
    protected String gmlNamespace;
    protected String gmlSchemaLocation;
    protected String baseType;
    protected String substitutionGroup;
    protected Map<String, String> describeFeatureTypeParams;
    protected String gmlPrefix;
    protected Configuration xmlConfiguration;
    protected volatile XSDElementDeclaration featureSubGroupElement;

    protected FeatureTypeSchemaBuilder(GeoServer gs) {
        this.wfs = (WFSInfo)gs.getService(WFSInfo.class);
        this.catalog = gs.getCatalog();
        this.resourceLoader = gs.getCatalog().getResourceLoader();
        this.profiles = new ArrayList();
        this.profiles.add(new XSProfile());
    }

    public Map<String, String> getDescribeFeatureTypeParams() {
        return this.describeFeatureTypeParams;
    }

    public Configuration getXmlConfiguration() {
        return this.xmlConfiguration;
    }

    public XSDSchema build(FeatureTypeInfo featureTypeInfo, String baseUrl) throws IOException {
        return this.build(new FeatureTypeInfo[]{featureTypeInfo}, baseUrl);
    }

    public XSDSchema build(FeatureTypeInfo[] featureTypeInfos, String baseUrl) throws IOException {
        return this.build(featureTypeInfos, baseUrl, true);
    }

    public XSDSchema build(FeatureTypeInfo[] featureTypeInfos, String baseUrl, boolean scheduleSchemaCleanup) throws IOException {
        XSDSchema schema = this.buildSchemaInternal(featureTypeInfos, baseUrl);
        if (schema != null && scheduleSchemaCleanup) {
            SchemaCleanerCallback.addSchema(schema);
        }
        return schema;
    }

    public XSDSchema buildSchemaInternal(FeatureTypeInfo[] featureTypeInfos, String baseUrl) throws IOException {
        XSDFactory factory = XSDFactory.eINSTANCE;
        XSDSchema schema = factory.createXSDSchema();
        schema.setSchemaForSchemaQNamePrefix("xsd");
        schema.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setElementFormDefault(XSDForm.get((int)0));
        HashMap<String, ArrayList<FeatureTypeInfo>> ns2featureTypeInfos = new HashMap<String, ArrayList<FeatureTypeInfo>>();
        int i = 0;
        while (i < featureTypeInfos.length) {
            String prefix = featureTypeInfos[i].getNamespace().getPrefix();
            ArrayList<FeatureTypeInfo> l = (ArrayList<FeatureTypeInfo>)ns2featureTypeInfos.get(prefix);
            if (l == null) {
                l = new ArrayList<FeatureTypeInfo>();
            }
            l.add(featureTypeInfos[i]);
            ns2featureTypeInfos.put(prefix, l);
            ++i;
        }
        if (baseUrl == null) {
            baseUrl = this.wfs.getSchemaBaseURL();
        }
        if (ns2featureTypeInfos.entrySet().size() == 1) {
            String targetPrefix = (String)ns2featureTypeInfos.keySet().iterator().next();
            String targetNamespace = this.catalog.getNamespaceByPrefix(targetPrefix).getURI();
            schema.setTargetNamespace(targetNamespace);
            schema.getQNamePrefixToNamespaceMap().put(targetPrefix, targetNamespace);
            for (NamespaceInfo nameSpaceinfo : this.catalog.getNamespaces()) {
                if (schema.getQNamePrefixToNamespaceMap().containsKey(nameSpaceinfo.getPrefix())) continue;
                schema.getQNamePrefixToNamespaceMap().put(nameSpaceinfo.getPrefix(), nameSpaceinfo.getURI());
            }
            try {
                FeatureType featureType = featureTypeInfos[0].getFeatureType();
                Object schemaUri = featureType.getUserData().get("schemaURI");
                if (schemaUri != null && schemaUri instanceof Map) {
                    Map schemaURIs = (Map)schemaUri;
                    if (!this.findTypeInSchema(featureTypeInfos[0], schema, factory)) {
                        ArrayList<String> importedNamespaces = new ArrayList<String>(ns2featureTypeInfos.size() + 1);
                        for (String namespace : schemaURIs.keySet()) {
                            if (targetNamespace.equals(namespace)) {
                                this.addInclude(schema, factory, (String)schemaURIs.get(namespace));
                                continue;
                            }
                            this.addImport(schema, factory, namespace, (String)schemaURIs.get(namespace), importedNamespaces);
                            importedNamespaces.add(namespace);
                        }
                    }
                    return schema;
                }
            }
            catch (IOException e) {
                logger.warning("Unable to get schema location for feature type '" + featureTypeInfos[0].getPrefixedName() + "'. Reason: '" + e.getMessage() + "'. Building the schema manually instead.");
            }
            this.importGMLSchema(schema, factory, baseUrl);
            schema.getQNamePrefixToNamespaceMap().put(this.gmlPrefix, this.gmlNamespace);
            int i2 = 0;
            while (i2 < featureTypeInfos.length) {
                try {
                    this.buildSchemaContent(featureTypeInfos[i2], schema, factory, baseUrl);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not build xml schema for type: " + featureTypeInfos[i2].getName(), e);
                }
                ++i2;
            }
        } else {
            ArrayList<String> importedNamespaces = new ArrayList<String>(ns2featureTypeInfos.size() + 1);
            for (Map.Entry entry : ns2featureTypeInfos.entrySet()) {
                String prefix = (String)entry.getKey();
                List types = (List)entry.getValue();
                StringBuffer typeNames = new StringBuffer();
                for (FeatureTypeInfo info : types) {
                    FeatureType featureType = info.getFeatureType();
                    Object schemaUri = featureType.getUserData().get("schemaURI");
                    if (schemaUri != null && schemaUri instanceof Map) {
                        Map schemaURIs = (Map)schemaUri;
                        for (String namespace : schemaURIs.keySet()) {
                            this.addImport(schema, factory, namespace, (String)schemaURIs.get(namespace), importedNamespaces);
                            importedNamespaces.add(namespace);
                        }
                        continue;
                    }
                    typeNames.append(info.getPrefixedName()).append(",");
                }
                if (typeNames.length() <= 0) continue;
                typeNames.setLength(typeNames.length() - 1);
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.describeFeatureTypeParams);
                params.put("typeName", typeNames.toString().trim());
                String schemaLocation = ResponseUtils.buildURL((String)baseUrl, (String)"wfs", params, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
                String namespace = this.catalog.getNamespaceByPrefix(prefix).getURI();
                XSDImport imprt = factory.createXSDImport();
                imprt.setNamespace(namespace);
                imprt.setSchemaLocation(schemaLocation);
                schema.getContents().add((Object)imprt);
            }
        }
        return schema;
    }

    protected void importGMLSchema(XSDSchema schema, XSDFactory factory, String baseUrl) {
        XSDImport imprt = factory.createXSDImport();
        imprt.setNamespace(this.gmlNamespace);
        imprt.setSchemaLocation(ResponseUtils.buildSchemaURL((String)baseUrl, (String)this.gmlSchemaLocation));
        XSDSchema gmlSchema = this.gmlSchema();
        imprt.setResolvedSchema(gmlSchema);
        schema.getContents().add((Object)imprt);
    }

    private void addInclude(XSDSchema schema, XSDFactory factory, String schemaLocation) {
        XSDInclude xsdInclude = factory.createXSDInclude();
        xsdInclude.setSchemaLocation(schemaLocation);
        schema.getContents().add((Object)xsdInclude);
        schema.updateElement();
    }

    private void addImport(XSDSchema schema, XSDFactory factory, String nsURI, String schemaURI, List<String> importedNamespaces) {
        if (!importedNamespaces.contains(nsURI)) {
            XSDImport xsdImport = factory.createXSDImport();
            xsdImport.setNamespace(nsURI);
            xsdImport.setSchemaLocation(schemaURI);
            schema.getContents().add((Object)xsdImport);
            importedNamespaces.add(nsURI);
        }
    }

    public XSDSchema addApplicationTypes(XSDSchema wfsSchema) throws IOException {
        List featureTypeInfos = this.catalog.getFeatureTypes();
        for (FeatureTypeInfo meta : featureTypeInfos) {
            if (!meta.enabled()) continue;
            XSDSchema schema = this.buildSchemaInternal(new FeatureTypeInfo[]{meta}, null);
            String prefix = meta.getNamespace().getPrefix();
            String namespaceURI = meta.getNamespace().getURI();
            wfsSchema.getQNamePrefixToNamespaceMap().put(prefix, namespaceURI);
            Iterator t = schema.getTypeDefinitions().iterator();
            while (t.hasNext()) {
                wfsSchema.getTypeDefinitions().add((Object)((XSDTypeDefinition)t.next()));
            }
            Iterator e = schema.getElementDeclarations().iterator();
            while (e.hasNext()) {
                wfsSchema.getElementDeclarations().add((Object)((XSDElementDeclaration)e.next()));
            }
            for (Map.Entry entry : schema.getQNamePrefixToNamespaceMap().entrySet()) {
                if (wfsSchema.getQNamePrefixToNamespaceMap().containsKey(entry.getKey())) continue;
                wfsSchema.getQNamePrefixToNamespaceMap().put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return wfsSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean findTypeInSchema(FeatureTypeInfo featureTypeMeta, XSDSchema schema, XSDFactory factory) throws IOException {
        Object content;
        String ws = featureTypeMeta.getStore().getWorkspace().getName();
        String ds = featureTypeMeta.getStore().getName();
        String name = featureTypeMeta.getName();
        File schemaFile = null;
        try {
            schemaFile = this.resourceLoader.find("workspaces/" + ws + "/" + ds + "/" + name + "/schema.xsd");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (schemaFile == null) return false;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Found customized schema.xsd: " + schemaFile.getAbsolutePath());
        }
        List resolvers = Schemas.findSchemaLocationResolvers((Configuration)this.xmlConfiguration);
        ArrayList<1> locators = new ArrayList<1>();
        locators.add(new XSDSchemaLocator(){

            public XSDSchema locateSchema(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
                if (FeatureTypeSchemaBuilder.this.gmlNamespace.equals(namespaceURI)) {
                    return FeatureTypeSchemaBuilder.this.gmlSchema();
                }
                return null;
            }
        });
        XSDSchema ftSchema = null;
        try {
            ftSchema = Schemas.parse((String)schemaFile.getAbsolutePath(), locators, (List)resolvers);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to parse schema: " + schemaFile.getAbsolutePath(), e);
        }
        if (ftSchema == null) return false;
        if (ftSchema.getSchemaForSchemaQNamePrefix() != null) {
            schema.setSchemaForSchemaQNamePrefix(ftSchema.getSchemaForSchemaQNamePrefix());
        }
        EList contents = ftSchema.getContents();
        boolean hasElement = false;
        Iterator i = contents.iterator();
        while (i.hasNext()) {
            XSDElementDeclaration element;
            XSDImport imprt;
            content = (XSDSchemaContent)i.next();
            content.setElement(null);
            if (content instanceof XSDImport && this.gmlNamespace.equals((imprt = (XSDImport)content).getNamespace())) {
                i.remove();
            }
            if (content instanceof XSDElementDeclaration) {
                if (this.contains((XSDNamedComponent)content, (List)schema.getElementDeclarations())) {
                    i.remove();
                }
            } else if (content instanceof XSDTypeDefinition && this.contains((XSDNamedComponent)content, (List)schema.getTypeDefinitions())) {
                i.remove();
            }
            if (hasElement || !(content instanceof XSDElementDeclaration) || !name.equals((element = (XSDElementDeclaration)content).getName()) || !featureTypeMeta.getNamespace().getURI().equals(element.getTargetNamespace())) continue;
            hasElement = true;
        }
        if (!hasElement) {
            XSDElementDeclaration element = factory.createXSDElementDeclaration();
            element.setName(featureTypeMeta.getName());
            element.setTargetNamespace(featureTypeMeta.getNamespace().getURI());
            content = Schemas.class;
            // MONITORENTER : org.geotools.xml.Schemas.class
            element.setSubstitutionGroupAffiliation(this.getFeatureElement());
            // MONITOREXIT : content
            ArrayList<XSDComplexTypeDefinition> candidates = new ArrayList<XSDComplexTypeDefinition>();
            block8: for (XSDTypeDefinition type : ftSchema.getTypeDefinitions()) {
                if (!(type instanceof XSDComplexTypeDefinition)) continue;
                XSDTypeDefinition base = type.getBaseType();
                while (base != null) {
                    if (this.baseType.equals(base.getName()) && this.gmlNamespace.equals(base.getTargetNamespace())) {
                        candidates.add((XSDComplexTypeDefinition)type);
                        continue block8;
                    }
                    if (base.equals(base.getBaseType())) continue block8;
                    base = base.getBaseType();
                }
            }
            if (candidates.size() != 1) {
                throw new IllegalStateException("Could not determine feature type for generated element. Must specify explicitly in schema.xsd.");
            }
            element.setTypeDefinition((XSDTypeDefinition)candidates.get(0));
            schema.getContents().add((Object)element);
        }
        schema.getContents().addAll((Collection)contents);
        schema.updateElement();
        Schemas.dispose((XSDSchema)ftSchema);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSDElementDeclaration getFeatureElement() {
        if (this.featureSubGroupElement == null) {
            FeatureTypeSchemaBuilder featureTypeSchemaBuilder = this;
            synchronized (featureTypeSchemaBuilder) {
                if (this.featureSubGroupElement == null) {
                    this.featureSubGroupElement = this.gmlSchema().resolveElementDeclaration(this.gmlNamespace, this.substitutionGroup);
                }
            }
        }
        return this.featureSubGroupElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildSchemaContent(FeatureTypeInfo featureTypeMeta, XSDSchema schema, XSDFactory factory, String baseUrl) throws IOException {
        if (this.findTypeInSchema(featureTypeMeta, schema, factory)) return;
        XSDComplexTypeDefinition xsdComplexType = this.buildComplexSchemaContent((ComplexType)featureTypeMeta.getFeatureType(), schema, factory);
        XSDElementDeclaration element = factory.createXSDElementDeclaration();
        element.setName(featureTypeMeta.getName());
        element.setTargetNamespace(featureTypeMeta.getNamespace().getURI());
        Class<Schemas> clazz = Schemas.class;
        synchronized (Schemas.class) {
            element.setSubstitutionGroupAffiliation(this.getFeatureElement());
            // ** MonitorExit[var7_7] (shouldn't be in output)
            element.setTypeDefinition((XSDTypeDefinition)xsdComplexType);
            schema.getContents().add((Object)element);
            schema.updateElement();
            return;
        }
    }

    private XSDComplexTypeDefinition buildComplexSchemaContent(ComplexType complexType, XSDSchema schema, XSDFactory factory) {
        XSDComplexTypeDefinition xsdComplexType = factory.createXSDComplexTypeDefinition();
        xsdComplexType.setName(String.valueOf(complexType.getName().getLocalPart()) + "Type");
        xsdComplexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        xsdComplexType.setBaseTypeDefinition(this.resolveTypeInSchema(schema, (Name)new NameImpl(this.gmlNamespace, this.baseType)));
        XSDModelGroup group = factory.createXSDModelGroup();
        group.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        for (PropertyDescriptor pd : complexType.getDescriptors()) {
            GMLInfo gml;
            AttributeDescriptor attribute;
            if (!(pd instanceof AttributeDescriptor) || this.filterAttributeType(attribute = (AttributeDescriptor)pd) && ((gml = this.getGMLConfig(this.wfs)) == null || !gml.getOverrideGMLAttributes().booleanValue())) continue;
            XSDElementDeclaration element = factory.createXSDElementDeclaration();
            element.setName(attribute.getLocalName());
            element.setNillable(attribute.isNillable());
            Name typeName = attribute.getType().getName();
            if (!typeName.getLocalPart().equals(XS.ANYTYPE.getLocalPart()) || !typeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                if (attribute.getType() instanceof ComplexType) {
                    if (schema.resolveTypeDefinition(typeName.getNamespaceURI(), typeName.getLocalPart()) == null) {
                        this.buildComplexSchemaContent((ComplexType)attribute.getType(), schema, factory);
                    }
                } else {
                    Class binding = attribute.getType().getBinding();
                    typeName = this.findTypeName(binding);
                    if (typeName == null) {
                        throw new NullPointerException("Could not find a type for property: " + attribute.getName() + " of type: " + binding.getName());
                    }
                }
            }
            XSDTypeDefinition type = this.resolveTypeInSchema(schema, typeName);
            element.setTypeDefinition(type);
            XSDParticle particle = factory.createXSDParticle();
            particle.setMinOccurs(attribute.getMinOccurs());
            particle.setMaxOccurs(attribute.getMaxOccurs());
            particle.setContent((XSDParticleContent)element);
            group.getContents().add((Object)particle);
        }
        XSDParticle particle = factory.createXSDParticle();
        particle.setContent((XSDParticleContent)group);
        xsdComplexType.setContent((XSDComplexTypeContent)particle);
        schema.getContents().add((Object)xsdComplexType);
        return xsdComplexType;
    }

    XSDTypeDefinition resolveTypeInSchema(XSDSchema schema, Name typeName) {
        XSDTypeDefinition type = null;
        for (XSDTypeDefinition td : schema.getTypeDefinitions()) {
            if (!typeName.getNamespaceURI().equals(td.getTargetNamespace()) || !typeName.getLocalPart().equals(td.getName())) continue;
            type = td;
            break;
        }
        if (type == null) {
            type = schema.resolveTypeDefinition(typeName.getNamespaceURI(), typeName.getLocalPart());
        }
        return type;
    }

    boolean contains(XSDNamedComponent c, List l) {
        boolean contains = false;
        Iterator i = l.iterator();
        while (!contains && i.hasNext()) {
            XSDNamedComponent e = (XSDNamedComponent)i.next();
            if (!e.getName().equals(c.getName())) continue;
            contains = e.getTargetNamespace() == null ? c.getTargetNamespace() == null : e.getTargetNamespace().equals(c.getTargetNamespace());
        }
        return contains;
    }

    Name findTypeName(Class binding) {
        for (Object profile : this.profiles) {
            Name name = null;
            if (profile instanceof TypeMappingProfile) {
                name = ((TypeMappingProfile)profile).name(binding);
            } else if (profile instanceof Schema) {
                Schema schema = (Schema)profile;
                for (Map.Entry e : schema.entrySet()) {
                    AttributeType at = (AttributeType)e.getValue();
                    if (at.getBinding() == null || !at.getBinding().equals(binding)) continue;
                    name = at.getName();
                    break;
                }
                if (name == null) {
                    for (AttributeType at : schema.values()) {
                        if (!binding.isAssignableFrom(at.getBinding())) continue;
                        name = at.getName();
                        break;
                    }
                }
            }
            if (name == null) continue;
            return name;
        }
        return null;
    }

    protected abstract XSDSchema gmlSchema();

    protected abstract GMLInfo getGMLConfig(WFSInfo var1);

    protected boolean filterAttributeType(AttributeDescriptor attribute) {
        return "name".equals(attribute.getLocalName()) || "description".equals(attribute.getLocalName()) || "boundedBy".equals(attribute.getLocalName());
    }

    public static final class GML2
    extends FeatureTypeSchemaBuilder {
        private static XSDSchema gml2Schema;

        public GML2(GeoServer gs) {
            super(gs);
            this.profiles.add(new GML2Profile());
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlSchemaLocation = "gml/2.1.2/feature.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "_Feature";
            this.describeFeatureTypeParams = ResponseUtils.params((String[])new String[]{"request", "DescribeFeatureType", "version", "1.0.0", "service", "WFS"});
            this.gmlPrefix = "gml";
            this.xmlConfiguration = new GMLConfiguration();
        }

        protected XSDSchema gmlSchema() {
            if (gml2Schema == null) {
                gml2Schema = this.xmlConfiguration.schema();
            }
            return gml2Schema;
        }

        protected GMLInfo getGMLConfig(WFSInfo wfs) {
            return wfs.getGML().get((Object)WFSInfo.Version.V_10);
        }
    }

    public static class GML3
    extends FeatureTypeSchemaBuilder {
        private static XSDSchema gml3Schema;

        public GML3(GeoServer gs) {
            super(gs);
            this.profiles.add(this.createTypeMappingProfile());
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlSchemaLocation = "gml/3.1.1/base/gml.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "_Feature";
            this.describeFeatureTypeParams = ResponseUtils.params((String[])new String[]{"request", "DescribeFeatureType", "version", "1.1.0", "service", "WFS"});
            this.gmlPrefix = "gml";
            this.xmlConfiguration = new org.geotools.gml3.GMLConfiguration();
        }

        Object createTypeMappingProfile() {
            return new GML3Profile();
        }

        protected XSDSchema gmlSchema() {
            if (gml3Schema == null) {
                gml3Schema = this.createGmlSchema();
            }
            return gml3Schema;
        }

        XSDSchema createGmlSchema() {
            return this.xmlConfiguration.schema();
        }

        protected boolean filterAttributeType(AttributeDescriptor attribute) {
            return super.filterAttributeType(attribute) || "metaDataProperty".equals(attribute.getLocalName()) || "location".equals(attribute.getLocalName());
        }

        protected GMLInfo getGMLConfig(WFSInfo wfs) {
            return wfs.getGML().get((Object)WFSInfo.Version.V_11);
        }
    }

    public static final class GML32
    extends GML3 {
        public GML32(GeoServer gs) {
            super(gs);
            this.gmlNamespace = "http://www.opengis.net/gml/3.2";
            this.gmlPrefix = "gml";
            this.gmlSchemaLocation = "gml/3.2.1/gml.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "AbstractFeature";
            this.describeFeatureTypeParams = ResponseUtils.params((String[])new String[]{"request", "DescribeFeatureType", "version", "1.1.0", "service", "WFS", "outputFormat", "text/xml; subtype=gml/3.2"});
            this.xmlConfiguration = new org.geotools.gml3.v3_2.GMLConfiguration();
        }

        Object createTypeMappingProfile() {
            return GML.getInstance().getTypeMappingProfile();
        }

        XSDSchema createGmlSchema() {
            try {
                return GML.getInstance().getSchema();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void importGMLSchema(XSDSchema schema, XSDFactory factory, String baseUrl) {
            try {
                XSDImport imprt = factory.createXSDImport();
                imprt.setNamespace(WFS.getInstance().getSchema().getTargetNamespace());
                imprt.setSchemaLocation(ResponseUtils.buildSchemaURL((String)baseUrl, (String)this.gmlSchemaLocation));
                imprt.setResolvedSchema(WFS.getInstance().getSchema());
                schema.getContents().add((Object)imprt);
                schema.getQNamePrefixToNamespaceMap().put("wfs", "http://www.opengis.net/wfs/2.0");
                ((XSDSchemaImpl)WFS.getInstance().getSchema()).imported(imprt);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected boolean filterAttributeType(AttributeDescriptor attribute) {
            return super.filterAttributeType(attribute) || "descriptionReference".equals(attribute.getLocalName()) || "identifier".equals(attribute.getLocalName());
        }
    }
}

