/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WebMapService;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.GetStylesRequest;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;
import org.vfny.geoserver.wms.responses.DescribeLayerResponse;
import org.vfny.geoserver.wms.responses.GetFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.WMSCapabilitiesResponse;
import org.vfny.geoserver.wms.responses.map.kml.KMLReflector;
import org.vfny.geoserver.wms.servlets.Capabilities;
import org.vfny.geoserver.wms.servlets.DescribeLayer;
import org.vfny.geoserver.wms.servlets.GetFeatureInfo;
import org.vfny.geoserver.wms.servlets.GetLegendGraphic;

public class DefaultWebMapService
implements WebMapService,
ApplicationContextAware {
    public static String FORMAT = "image/png";
    public static List STYLES = Collections.EMPTY_LIST;
    public static int MAX_SIDE = 512;
    public static int MIN_OL_HEIGHT = 330;
    public static String SRS = "EPSG:4326";
    public static Boolean TRANSPARENT = Boolean.TRUE;
    public static ReferencedEnvelope BBOX = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    WMS wms;
    ApplicationContext context;
    private static Boolean OPTIMIZE_LINE_WIDTH = null;
    private static Boolean USE_STREAMING_RENDERER = null;
    public static Integer MAX_FILTER_RULES = null;
    private static Boolean ADVANCED_PROJECTION_HANDLING = null;

    public DefaultWebMapService(WMS wms) {
        this.wms = wms;
    }

    public WMSInfo getServiceInfo() {
        return this.wms.getServiceInfo();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        String enabled;
        this.context = context;
        if (OPTIMIZE_LINE_WIDTH == null) {
            enabled = GeoServerExtensions.getProperty((String)"OPTIMIZE_LINE_WIDTH", (ApplicationContext)context);
            OPTIMIZE_LINE_WIDTH = enabled == null ? Boolean.valueOf(false) : Boolean.valueOf(enabled);
        }
        if (USE_STREAMING_RENDERER == null) {
            enabled = GeoServerExtensions.getProperty((String)"USE_STREAMING_RENDERER", (ApplicationContext)context);
            USE_STREAMING_RENDERER = enabled == null ? Boolean.valueOf(false) : Boolean.valueOf(enabled);
        }
        if (MAX_FILTER_RULES == null) {
            String rules = GeoServerExtensions.getProperty((String)"MAX_FILTER_RULES", (ApplicationContext)context);
            MAX_FILTER_RULES = rules == null ? Integer.valueOf(20) : Integer.valueOf(rules);
        }
        if (ADVANCED_PROJECTION_HANDLING == null) {
            enabled = GeoServerExtensions.getProperty((String)"ADVANCED_PROJECTION_HANDLING", (ApplicationContext)context);
            ADVANCED_PROJECTION_HANDLING = enabled == null ? Boolean.valueOf(false) : Boolean.valueOf(enabled);
        }
    }

    public static boolean isLineWidthOptimizationEnabled() {
        return OPTIMIZE_LINE_WIDTH;
    }

    public static boolean useStreamingRenderer() {
        return USE_STREAMING_RENDERER;
    }

    public static int getMaxFilterRules() {
        return MAX_FILTER_RULES;
    }

    public static boolean isAdvancedProjectionHandlingEnabled() {
        return ADVANCED_PROJECTION_HANDLING;
    }

    public WMSCapabilitiesResponse getCapabilities(WMSCapabilitiesRequest request) {
        Capabilities capabilities = (Capabilities)((Object)this.context.getBean("wmsGetCapabilities"));
        return (WMSCapabilitiesResponse)capabilities.getResponse();
    }

    public WMSCapabilitiesResponse capabilities(WMSCapabilitiesRequest request) {
        return this.getCapabilities(request);
    }

    public DescribeLayerResponse describeLayer(DescribeLayerRequest request) {
        DescribeLayer describeLayer = (DescribeLayer)((Object)this.context.getBean("wmsDescribeLayer"));
        return (DescribeLayerResponse)describeLayer.getResponse();
    }

    public GetMapResponse getMap(GetMapRequest request) {
        return new GetMapResponse(WMSExtensions.findMapProducers(this.context));
    }

    public GetMapResponse map(GetMapRequest request) {
        return this.getMap(request);
    }

    public GetFeatureInfoResponse getFeatureInfo(GetFeatureInfoRequest request) {
        GetFeatureInfo getFeatureInfo = (GetFeatureInfo)((Object)this.context.getBean("wmsGetFeatureInfo"));
        return (GetFeatureInfoResponse)getFeatureInfo.getResponse();
    }

    public GetLegendGraphicResponse getLegendGraphic(GetLegendGraphicRequest request) {
        GetLegendGraphic getLegendGraphic = (GetLegendGraphic)((Object)this.context.getBean("wmsGetLegendGraphic"));
        return (GetLegendGraphicResponse)getLegendGraphic.getResponse();
    }

    public void kml(GetMapRequest getMap, HttpServletResponse response) {
        try {
            KMLReflector.doWms(getMap, response, this, this.wms);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GetMapResponse reflect(GetMapRequest request) {
        return this.getMapReflect(request);
    }

    public StyledLayerDescriptor getStyles(GetStylesRequest request) {
        if (request.getSldVer() != null && "".equals(request.getSldVer()) && !"1.0.0".equals(request.getSldVer())) {
            throw new WmsException("SLD version " + request.getSldVer() + " not supported");
        }
        try {
            StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
            ArrayList<NamedLayer> layers = new ArrayList<NamedLayer>();
            for (String layerName : request.getLayers()) {
                NamedLayer namedLayer = factory.createNamedLayer();
                layers.add(namedLayer);
                namedLayer.setName(layerName);
                LayerGroupInfo group = this.wms.getLayerGroupByName(layerName);
                LayerInfo layer = this.wms.getLayerByName(layerName);
                if (group != null) continue;
                if (layer != null) {
                    Style style = layer.getDefaultStyle().getStyle();
                    style = this.cloneStyle(style);
                    style.setDefault(true);
                    style.setName(layer.getDefaultStyle().getName());
                    namedLayer.styles().add(style);
                    for (StyleInfo si : layer.getStyles()) {
                        style = this.cloneStyle(si.getStyle());
                        style.setName(si.getName());
                        namedLayer.styles().add(style);
                    }
                    continue;
                }
                throw new WmsException("Unknown layer " + layerName);
            }
            StyledLayerDescriptor sld = factory.createStyledLayerDescriptor();
            sld.setStyledLayers(layers.toArray(new StyledLayer[layers.size()]));
            return sld;
        }
        catch (IOException e) {
            throw new WmsException(e);
        }
    }

    private Style cloneStyle(Style style) {
        DuplicatingStyleVisitor cloner = new DuplicatingStyleVisitor();
        style.accept((StyleVisitor)cloner);
        style = (Style)cloner.getCopy();
        return style;
    }

    public GetMapResponse getMapReflect(GetMapRequest request) {
        GetMapRequest getMap = request;
        if (getMap.getFormat() == null) {
            getMap.setFormat(FORMAT);
        }
        if (getMap.getStyles() == null || getMap.getStyles().isEmpty()) {
            if (getMap.getLayers() != null && getMap.getLayers().length > 0) {
                ArrayList<Style> styles = new ArrayList<Style>(getMap.getLayers().length);
                for (int i = 0; i < getMap.getLayers().length; ++i) {
                    styles.add(getMap.getLayers()[i].getDefaultStyle());
                }
                getMap.setStyles(styles);
            } else {
                getMap.setStyles(STYLES);
            }
        }
        DefaultWebMapService.autoSetBoundsAndSize(getMap);
        return this.getMap(getMap);
    }

    public static void autoSetBoundsAndSize(GetMapRequest getMap) {
        CoordinateReferenceSystem reqCRS;
        MapLayerInfo[] layers = getMap.getLayers();
        String reqSRS = getMap.getSRS();
        boolean useNativeBounds = true;
        if (reqSRS == null) {
            reqSRS = DefaultWebMapService.guessCommonSRS(layers);
            DefaultWebMapService.forceSRS(getMap, reqSRS);
        }
        for (int i = 0; useNativeBounds && i < layers.length; ++i) {
            String layerSRS;
            useNativeBounds = layers[i] != null ? reqSRS.equalsIgnoreCase(layerSRS = layers[i].getSRS()) && layers[i].getResource().getNativeBoundingBox() != null : false;
        }
        try {
            reqCRS = CRS.decode((String)reqSRS);
        }
        catch (Exception e) {
            throw new WmsException(e);
        }
        Envelope aggregateBbox = getMap.getBbox();
        boolean specifiedBbox = true;
        if (aggregateBbox == null) {
            specifiedBbox = false;
            for (int i = 0; i < layers.length; ++i) {
                ReferencedEnvelope curbbox;
                block34: {
                    MapLayerInfo layerInfo = layers[i];
                    try {
                        curbbox = layerInfo.getLatLongBoundingBox();
                        if (!useNativeBounds) break block34;
                        ReferencedEnvelope nativeBbox = layerInfo.getBoundingBox();
                        if (nativeBbox == null) {
                            try {
                                CoordinateReferenceSystem nativeCrs = layerInfo.getCoordinateReferenceSystem();
                                nativeBbox = curbbox.transform(nativeCrs, true);
                            }
                            catch (Exception e) {
                                throw new WmsException("Best effort native bbox computation failed", "", e);
                            }
                        }
                        curbbox = nativeBbox;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (aggregateBbox != null) {
                    aggregateBbox.expandToInclude((Envelope)curbbox);
                    continue;
                }
                aggregateBbox = curbbox;
            }
            ReferencedEnvelope ref = null;
            if (!useNativeBounds && !reqSRS.equalsIgnoreCase(SRS)) {
                try {
                    ref = new ReferencedEnvelope(aggregateBbox, CRS.decode((String)"EPSG:4326"));
                    aggregateBbox = ref.transform(reqCRS, true);
                }
                catch (ProjectionException pe) {
                    ref.expandBy(-1.0 * ref.getWidth() / 50.0, -1.0 * ref.getHeight() / 50.0);
                    try {
                        aggregateBbox = ref.transform(reqCRS, true);
                    }
                    catch (FactoryException e) {
                        e.printStackTrace();
                    }
                    catch (TransformException e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchAuthorityCodeException e) {
                    e.printStackTrace();
                }
                catch (TransformException e) {
                    e.printStackTrace();
                }
                catch (FactoryException e) {
                    e.printStackTrace();
                }
            }
        }
        if (aggregateBbox == null) {
            DefaultWebMapService.forceSRS(getMap, SRS);
            aggregateBbox = BBOX;
        }
        double bbheight = aggregateBbox.getHeight();
        double bbwidth = aggregateBbox.getWidth();
        double bbratio = bbwidth / bbheight;
        double mheight = getMap.getHeight();
        double mwidth = getMap.getWidth();
        if (!(mheight > 0.5 && mwidth > 0.5 && specifiedBbox)) {
            if (mheight > 0.5 && mwidth > 0.5) {
                double mratio = mwidth / mheight;
                if (bbratio > mratio) {
                    double diff = (bbwidth / mratio - bbheight) / 2.0;
                    aggregateBbox.expandBy(0.0, diff);
                } else {
                    double diff = (bbheight * mratio - bbwidth) / 2.0;
                    aggregateBbox.expandBy(diff, 0.0);
                }
                DefaultWebMapService.adjustBounds(reqSRS, aggregateBbox);
            } else if (mheight > 0.5) {
                mwidth = bbratio * mheight;
            } else if (mwidth > 0.5) {
                mheight = mwidth / bbratio >= 1.0 ? mwidth / bbratio : 1.0;
            } else {
                if (bbratio > 1.0) {
                    mwidth = MAX_SIDE;
                    mheight = mwidth / bbratio >= 1.0 ? mwidth / bbratio : 1.0;
                } else {
                    mheight = MAX_SIDE;
                    double d = mwidth = mheight * bbratio >= 1.0 ? mheight * bbratio : 1.0;
                }
                if (mheight < (double)MIN_OL_HEIGHT && ("application/openlayers".equalsIgnoreCase(getMap.getFormat()) || "openlayers".equalsIgnoreCase(getMap.getFormat()))) {
                    mheight = MIN_OL_HEIGHT;
                    mwidth = mheight * bbratio >= 1.0 ? mheight * bbratio : 1.0;
                }
            }
            getMap.setBbox(aggregateBbox);
            getMap.setWidth((int)mwidth);
            getMap.setHeight((int)mheight);
        }
    }

    private static String guessCommonSRS(MapLayerInfo[] layers) {
        String SRS = null;
        for (MapLayerInfo layer : layers) {
            String layerSRS = layer.getSRS();
            if (SRS == null) {
                SRS = layerSRS.toUpperCase();
                continue;
            }
            if (SRS.equals(layerSRS)) continue;
            return DefaultWebMapService.SRS;
        }
        if (SRS == null) {
            return DefaultWebMapService.SRS;
        }
        return SRS;
    }

    private static void forceSRS(GetMapRequest getMap, String srs) {
        getMap.setSRS(srs);
        try {
            getMap.setCrs(CRS.decode((String)srs));
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    private static Envelope adjustBounds(String reqSRS, Envelope bbox) {
        if (reqSRS.equalsIgnoreCase("EPSG:4326")) {
            bbox.expandBy(bbox.getWidth() / 100.0, bbox.getHeight() / 100.0);
            Envelope maxEnv = new Envelope(-180.0, -90.0, 180.0, 90.0);
            return bbox.intersection(maxEnv);
        }
        if (reqSRS.equalsIgnoreCase("EPSG:900913")) {
            bbox.expandBy(bbox.getWidth() / 100.0, bbox.getHeight() / 100.0);
            Envelope maxEnv = new Envelope(-2.003750833E7, -2.003750833E7, 2.003750833E7, 2.003750833E7);
            return bbox.intersection(maxEnv);
        }
        return bbox;
    }
}

