/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;

public class CapabilitiesKvpReader
extends KvpRequestReader {
    private WMS wms;

    public CapabilitiesKvpReader(Map kvPairs, WMS wms) {
        super(kvPairs, (ServiceInfo)wms.getServiceInfo());
        this.wms = wms;
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        WMSCapabilitiesRequest currentRequest = new WMSCapabilitiesRequest(this.wms);
        currentRequest.setHttpServletRequest(request);
        String reqVersion = this.wms.getVersion();
        if (this.keyExists("VERSION")) {
            reqVersion = this.getValue("VERSION");
        } else if (this.keyExists("WMTVER")) {
            reqVersion = this.getValue("WMTVER");
        }
        currentRequest.setVersion(reqVersion);
        if (this.keyExists("UPDATESEQUENCE")) {
            currentRequest.setUpdateSequence(this.getValue("UPDATESEQUENCE"));
        }
        if (this.keyExists("NAMESPACE")) {
            currentRequest.setNamespace(this.getValue("NAMESPACE"));
        }
        return currentRequest;
    }
}

