/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;
import org.opengis.util.ProgressListener;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;

public class GetLegendGraphicKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger((String)GetLegendGraphicKvpReader.class.getPackage().getName());
    private static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());

    public GetLegendGraphicKvpReader(Map params, WMS wms) {
        super(params, wms);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        GetLegendGraphicRequest request = new GetLegendGraphicRequest(this.getWMS());
        request.setHttpServletRequest(httpRequest);
        String version = super.getRequestVersion();
        String layer = this.getValue("LAYER");
        String format = this.getValue("FORMAT");
        String strictParam = this.getValue("STRICT");
        boolean strict = strictParam == null ? true : Boolean.valueOf(strictParam);
        request.setStrict(strict);
        if (strict && layer == null) {
            throw new ServiceException("LAYER parameter not present for GetLegendGraphic", "LayerNotDefined");
        }
        if (strict && format == null) {
            throw new ServiceException("Missing FORMAT parameter for GetLegendGraphic", "MissingFormat");
        }
        WMS wms = request.getWMS();
        MapLayerInfo mli = null;
        if (layer != null) {
            LayerInfo layerInfo = wms.getLayerByName(layer);
            if (layerInfo == null) {
                throw new WmsException(layer + " layer does not exists.");
            }
            mli = new MapLayerInfo(layerInfo);
            try {
                if (layerInfo.getType() == LayerInfo.Type.VECTOR) {
                    FeatureType featureType = mli.getFeature().getFeatureType();
                    request.setLayer(featureType);
                } else if (layerInfo.getType() == LayerInfo.Type.RASTER) {
                    CoverageInfo coverageInfo = mli.getCoverage();
                    AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)coverageInfo.getGridCoverageReader((ProgressListener)new NullProgressListener(), GeoTools.getDefaultHints());
                    FeatureCollection feature = FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, null);
                    request.setLayer(feature.getSchema());
                }
            }
            catch (IOException e) {
                throw new WmsException(e);
            }
            catch (NoSuchElementException ne) {
                throw new WmsException(ne, new StringBuffer(layer).append(" layer does not exists.").toString(), ne.getLocalizedMessage());
            }
            catch (Exception te) {
                throw new WmsException(te, "Can't obtain the schema for the required layer.", te.getLocalizedMessage());
            }
        }
        if (format != null && !GetLegendGraphicResponse.supportsFormat(format)) {
            throw new WmsException(new StringBuffer("Invalid graphic format: ").append(format).toString(), "InvalidFormat");
        }
        request.setFormat(format);
        try {
            this.parseOptionalParameters(request, mli);
        }
        catch (IOException e) {
            throw new WmsException(e);
        }
        return request;
    }

    private void parseOptionalParameters(GetLegendGraphicRequest req, MapLayerInfo mli) throws IOException {
        String exceptions;
        String height;
        String width;
        this.parseStyleAndRule(req, mli);
        String featureType = this.getValue("FEATURETYPE");
        String scale = this.getValue("SCALE");
        if (scale != null && !"".equals(scale)) {
            double scaleFactor = Double.valueOf(scale);
            req.setScale(scaleFactor);
        }
        if ((width = this.getValue("WIDTH")) != null && !"".equals(width)) {
            int legendW = Integer.valueOf(width);
            req.setWidth(legendW);
        }
        if ((height = this.getValue("HEIGHT")) != null && !"".equals(height)) {
            int legendH = Integer.valueOf(height);
            req.setHeight(legendH);
        }
        if ((exceptions = this.getValue("EXCEPTIONS")) != null) {
            req.setExceptionsFormat(exceptions);
        }
        String transparentParam = this.getValue("TRANSPARENT");
        boolean transparentBackground = "true".equalsIgnoreCase(transparentParam);
        req.setTransparent(transparentBackground);
        req.setLegendOptions(Requests.parseOptionParameter((String)this.getValue("LEGEND_OPTIONS")));
    }

    private void parseStyleAndRule(GetLegendGraphicRequest req, MapLayerInfo layer) throws IOException {
        Style[] styles;
        String styleName = this.getValue("STYLE");
        String sldUrl = this.getValue("SLD");
        String sldBody = this.getValue("SLD_BODY");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("looking for style ").append(styleName).toString());
        }
        Style sldStyle = null;
        if (sldUrl != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD parameter");
            }
            styles = this.loadRemoteStyle(sldUrl);
            sldStyle = this.findStyle(styleName, styles);
        } else if (sldBody != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD_BODY parameter");
            }
            styles = this.parseSldBody(sldBody);
            sldStyle = this.findStyle(styleName, styles);
        } else if (styleName != null && !"".equals(styleName)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from STYLE parameter");
            }
            sldStyle = this.getWMS().getStyleByName(styleName);
        } else {
            sldStyle = layer.getDefaultStyle();
        }
        req.setStyle(sldStyle);
        String rule = this.getValue("RULE");
        Rule sldRule = this.extractRule(sldStyle, rule);
        if (sldRule != null) {
            req.setRule(sldRule);
        }
    }

    private Style findStyle(String styleName, Style[] styles) throws NoSuchElementException {
        if (styles == null || styles.length == 0) {
            throw new NoSuchElementException("No styles have been provided to search for " + styleName);
        }
        if (styleName == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("styleName is null, request in literal mode, returning first style");
            }
            return styles[0];
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("request in library mode, looking for style ").append(styleName).toString());
        }
        StringBuffer noMatchNames = new StringBuffer();
        for (int i = 0; i < styles.length; ++i) {
            if (styles[i] != null && styleName.equals(styles[i].getName())) {
                return styles[i];
            }
            noMatchNames.append(styles[i].getName());
            if (i >= styles.length) continue;
            noMatchNames.append(", ");
        }
        throw new NoSuchElementException(styleName + " not found. Provided style names: " + noMatchNames);
    }

    private Style[] loadRemoteStyle(String sldUrl) throws WmsException {
        InputStream in;
        try {
            URL url = new URL(sldUrl);
            in = url.openStream();
        }
        catch (MalformedURLException e) {
            throw new WmsException(e, "Not a valid URL to an SLD document " + sldUrl, "loadRemoteStyle");
        }
        catch (IOException e) {
            throw new WmsException(e, "Can't open the SLD URL " + sldUrl, "loadRemoteStyle");
        }
        return this.parseSld(new InputStreamReader(in));
    }

    private Style[] parseSldBody(String sldBody) throws WmsException {
        return this.parseSld(new StringReader(sldBody));
    }

    private Style[] parseSld(Reader xmlIn) throws WmsException {
        SLDParser parser = new SLDParser(styleFactory, xmlIn);
        Style[] styles = null;
        try {
            styles = parser.readXML();
        }
        catch (RuntimeException e) {
            throw new WmsException(e);
        }
        if (styles == null || styles.length == 0) {
            throw new WmsException("Document contains no styles");
        }
        return styles;
    }

    private Rule extractRule(Style sldStyle, String rule) throws WmsException {
        Rule sldRule = null;
        if (rule != null && !"".equals(rule)) {
            FeatureTypeStyle[] fts = sldStyle.getFeatureTypeStyles();
            block0: for (int i = 0; i < fts.length; ++i) {
                Rule[] rules = fts[i].getRules();
                for (int r = 0; r < rules.length; ++r) {
                    if (!rule.equalsIgnoreCase(rules[r].getName())) continue;
                    sldRule = rules[r];
                    if (!LOGGER.isLoggable(Level.FINE)) continue block0;
                    LOGGER.fine(new StringBuffer("found requested rule: ").append(rule).toString());
                    continue block0;
                }
            }
            if (sldRule == null) {
                throw new WmsException("Style " + sldStyle.getName() + " does not contains a rule named " + rule);
            }
        }
        return sldRule;
    }
}

