/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.raster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.vfny.geoserver.wms.responses.legend.raster.ColorManager;

class SimpleColorManager
extends ColorManager {
    public SimpleColorManager(Color color, double opacity, Dimension requestedDimension, Color borderColor) {
        super(color, opacity, requestedDimension, borderColor);
    }

    public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
        if (this.bkgOpacity > 0.0) {
            Color oldColor = graphics.getColor();
            Color newColor = new Color(this.bkgColor.getRed(), this.bkgColor.getGreen(), this.bkgColor.getBlue(), (int)(255.0 * this.bkgOpacity + 0.5));
            graphics.setColor(newColor);
            graphics.fill(clipBox);
            graphics.setColor(this.borderColor);
            if (completeBorder) {
                int minx = (int)(clipBox.getMinX() + 0.5);
                int miny = (int)(clipBox.getMinY() + 0.5);
                int w = (int)(clipBox.getWidth() + 0.5) - 1;
                int h = (int)(clipBox.getHeight() + 0.5) - 1;
                graphics.draw(new Rectangle2D.Double(minx, miny, w, h));
            }
            graphics.setColor(oldColor);
        } else {
            Color oldColor = graphics.getColor();
            graphics.setColor(Color.white);
            graphics.fill(clipBox);
            graphics.setColor(Color.RED);
            int minx = (int)(clipBox.getMinX() + 0.5);
            int miny = (int)(clipBox.getMinY() + 0.5);
            int maxx = (int)((double)minx + clipBox.getWidth() - 1.0 + 0.5);
            int maxy = (int)((double)miny + clipBox.getHeight() - 1.0 + 0.5);
            graphics.drawLine(minx, miny, maxx, maxy);
            graphics.drawLine(minx, maxy, maxx, miny);
            graphics.setColor(this.borderColor);
            if (completeBorder) {
                int w = (int)(clipBox.getWidth() + 0.5) - 1;
                int h = (int)(clipBox.getHeight() + 0.5) - 1;
                graphics.draw(new Rectangle2D.Double(minx, miny, w, h));
            }
            graphics.setColor(oldColor);
        }
    }
}

