/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererUtilities;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGetMapProducer
implements GetMapProducer {
    protected WMSMapContext mapContext;
    protected boolean abortRequested;
    protected GTRenderer renderer;
    protected String requestedOutputFormat;
    private final String mime;
    private final Set<String> outputFormatNames;

    protected AbstractGetMapProducer(String mime, String outputFormat) {
        this(mime, new String[]{outputFormat});
    }

    protected AbstractGetMapProducer(String mime, String[] outputFormats) {
        this(mime, outputFormats != null ? Arrays.asList(outputFormats) : null);
    }

    protected AbstractGetMapProducer(String mime, Collection<String> outputFormats) {
        this.mime = mime;
        if (outputFormats == null) {
            outputFormats = Collections.emptySet();
        }
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        names.addAll(outputFormats);
        this.outputFormatNames = Collections.unmodifiableSet(names);
    }

    protected AbstractGetMapProducer() {
        this((String)null, (String[])null);
    }

    @Override
    public void setMapContext(WMSMapContext mapContext) {
        this.mapContext = mapContext;
    }

    @Override
    public WMSMapContext getMapContext() {
        return this.mapContext;
    }

    @Override
    public void abort() {
        this.abortRequested = true;
        if (this.renderer != null) {
            this.renderer.stopRendering();
        }
    }

    public String getContentEncoding() {
        return null;
    }

    @Override
    public String getContentType() {
        return this.mime;
    }

    @Override
    public String getOutputFormat() {
        return this.requestedOutputFormat == null ? this.getContentType() : this.requestedOutputFormat;
    }

    @Override
    public void setOutputFormat(String outputFormat) {
        if (!this.outputFormatNames.contains(outputFormat)) {
            throw new IllegalArgumentException(String.valueOf(outputFormat) + " is not a recognized output " + "format for " + this.getClass().getSimpleName());
        }
        this.requestedOutputFormat = outputFormat;
    }

    @Override
    public String getContentDisposition() {
        return null;
    }

    protected String getContentDisposition(String extension) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.mapContext.getLayerCount()) {
            MapLayer layer = this.mapContext.getLayer(i);
            String title = layer.getTitle();
            if (title != null && !title.equals("")) {
                sb.append(title).append("_");
            }
            ++i;
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return "attachment; filename=" + sb.toString() + extension;
        }
        return "attachment; filename=geoserver" + extension;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return this.outputFormatNames;
    }

    protected AffineTransform getRenderingTransform() {
        AffineTransform tx;
        Rectangle paintArea = new Rectangle(0, 0, this.mapContext.getMapWidth(), this.mapContext.getMapHeight());
        ReferencedEnvelope dataArea = this.mapContext.getAreaOfInterest();
        if (this.mapContext.getAngle() != 0.0) {
            tx = new AffineTransform();
            tx.translate(paintArea.width / 2, paintArea.height / 2);
            tx.rotate(Math.toRadians(this.mapContext.getAngle()));
            tx.translate(-paintArea.width / 2, -paintArea.height / 2);
            tx.concatenate(RendererUtilities.worldToScreenTransform((ReferencedEnvelope)dataArea, (Rectangle)paintArea));
        } else {
            tx = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)dataArea, (Rectangle)paintArea);
        }
        return tx;
    }

    protected ReferencedEnvelope getRenderingArea() {
        if (this.mapContext.getAngle() == 0.0) {
            return this.mapContext.getAreaOfInterest();
        }
        ReferencedEnvelope dataArea = this.mapContext.getAreaOfInterest();
        AffineTransform tx = new AffineTransform();
        double offsetX = dataArea.getMinX() + dataArea.getWidth() / 2.0;
        double offsetY = dataArea.getMinY() + dataArea.getHeight() / 2.0;
        tx.translate(offsetX, offsetY);
        tx.rotate(Math.toRadians(this.mapContext.getAngle()));
        tx.translate(-offsetX, -offsetY);
        Rectangle2D.Double dataAreaShape = new Rectangle2D.Double(dataArea.getMinX(), dataArea.getMinY(), dataArea.getWidth(), dataArea.getHeight());
        Rectangle2D transformedBounds = tx.createTransformedShape(dataAreaShape).getBounds2D();
        return new ReferencedEnvelope(transformedBounds, this.mapContext.getAreaOfInterest().getCoordinateReferenceSystem());
    }
}

